@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getQuotaApplications.
 * @property applications
 * @property dimensions
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyWord
 * @property outputFile
 * @property productCode
 * @property quotaActionCode
 * @property quotaCategory
 * @property status
 */
public data class GetQuotaApplicationsResult(
    public val applications: List<GetQuotaApplicationsApplication>,
    public val dimensions: List<GetQuotaApplicationsDimension>? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val keyWord: String? = null,
    public val outputFile: String? = null,
    public val productCode: String,
    public val quotaActionCode: String? = null,
    public val quotaCategory: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetQuotaApplicationsResult): GetQuotaApplicationsResult = GetQuotaApplicationsResult(
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaApplicationsApplication.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaApplicationsDimension.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyWord = javaType.keyWord().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productCode = javaType.productCode(),
            quotaActionCode = javaType.quotaActionCode().map({ args0 -> args0 }).orElse(null),
            quotaCategory = javaType.quotaCategory().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
