@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property adjustable Is the quota adjustable.
 * @property applicableRanges The range of quota adjustment.
 * @property applicableType The type of quota.
 * @property consumable Show used quota.
 * @property id The ID of the Quota.
 * @property quotaActionCode The quota action code.
 * @property quotaDescription The quota description.
 * @property quotaName The quota name.
 * @property quotaType The quota type.
 * @property quotaUnit The quota unit.
 * @property totalQuota TotalQuota.
 * @property totalUsage The total of usage.
 * @property unadjustableDetail The unadjustable detail.
 */
public data class GetQuotasQuota(
    public val adjustable: Boolean,
    public val applicableRanges: List<String>,
    public val applicableType: String,
    public val consumable: Boolean,
    public val id: String,
    public val quotaActionCode: String,
    public val quotaDescription: String,
    public val quotaName: String,
    public val quotaType: String,
    public val quotaUnit: String,
    public val totalQuota: Double,
    public val totalUsage: Double,
    public val unadjustableDetail: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetQuotasQuota): GetQuotasQuota = GetQuotasQuota(
            adjustable = javaType.adjustable(),
            applicableRanges = javaType.applicableRanges().map({ args0 -> args0 }),
            applicableType = javaType.applicableType(),
            consumable = javaType.consumable(),
            id = javaType.id(),
            quotaActionCode = javaType.quotaActionCode(),
            quotaDescription = javaType.quotaDescription(),
            quotaName = javaType.quotaName(),
            quotaType = javaType.quotaType(),
            quotaUnit = javaType.quotaUnit(),
            totalQuota = javaType.totalQuota(),
            totalUsage = javaType.totalUsage(),
            unadjustableDetail = javaType.unadjustableDetail(),
        )
    }
}
