@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getQuotas.
 * @property dimensions
 * @property groupCode
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyWord
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property productCode
 * @property quotaActionCode
 * @property quotaCategory
 * @property quotas
 * @property sortField
 * @property sortOrder
 */
public data class GetQuotasResult(
    public val dimensions: List<GetQuotasDimension>? = null,
    public val groupCode: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val keyWord: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val productCode: String,
    public val quotaActionCode: String? = null,
    public val quotaCategory: String? = null,
    public val quotas: List<GetQuotasQuota>,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetQuotasResult): GetQuotasResult = GetQuotasResult(
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotasDimension.Companion.toKotlin(args0)
                })
            }),
            groupCode = javaType.groupCode().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyWord = javaType.keyWord().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productCode = javaType.productCode(),
            quotaActionCode = javaType.quotaActionCode().map({ args0 -> args0 }).orElse(null),
            quotaCategory = javaType.quotaCategory().map({ args0 -> args0 }).orElse(null),
            quotas = javaType.quotas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotasQuota.Companion.toKotlin(args0)
                })
            }),
            sortField = javaType.sortField().map({ args0 -> args0 }).orElse(null),
            sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
        )
    }
}
