@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aliyunUids The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.> Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
 * @property applyTime The UTC time of the quota increase application.
 * @property auditStatusVos Quantity of requisitions in different approval statuses.
 * @property batchQuotaApplicationId The ID of the quota application batch.
 * @property desireValue The value of the quota request.> The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
 * @property dimensions Quota dimension.
 * @property effectiveTime The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).> If the current account does not select the effective time, the default is the submission time.
 * @property expireTime The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).> If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
 * @property id The ID of the quota application batch.
 * @property productCode Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
 * @property quotaActionCode The quota ID.
 * @property quotaCategory The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
 * @property reason Reason for quota application.> The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
 */
public data class GetTemplateApplicationsApplication(
    public val aliyunUids: List<String>,
    public val applyTime: String,
    public val auditStatusVos: List<GetTemplateApplicationsApplicationAuditStatusVo>,
    public val batchQuotaApplicationId: String,
    public val desireValue: Double,
    public val dimensions: List<GetTemplateApplicationsApplicationDimension>,
    public val effectiveTime: String,
    public val expireTime: String,
    public val id: String,
    public val productCode: String,
    public val quotaActionCode: String,
    public val quotaCategory: String,
    public val reason: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetTemplateApplicationsApplication): GetTemplateApplicationsApplication = GetTemplateApplicationsApplication(
            aliyunUids = javaType.aliyunUids().map({ args0 -> args0 }),
            applyTime = javaType.applyTime(),
            auditStatusVos = javaType.auditStatusVos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetTemplateApplicationsApplicationAuditStatusVo.Companion.toKotlin(args0)
                })
            }),
            batchQuotaApplicationId = javaType.batchQuotaApplicationId(),
            desireValue = javaType.desireValue(),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetTemplateApplicationsApplicationDimension.Companion.toKotlin(args0)
                })
            }),
            effectiveTime = javaType.effectiveTime(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            productCode = javaType.productCode(),
            quotaActionCode = javaType.quotaActionCode(),
            quotaCategory = javaType.quotaCategory(),
            reason = javaType.reason(),
        )
    }
}
