@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTemplateApplications.
 * @property applications A list of Template Applications Entries. Each element contains the following attributes:
 * @property batchQuotaApplicationId The ID of the quota application batch.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Template Applications IDs.
 * @property outputFile
 * @property productCode Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
 * @property quotaActionCode The quota ID.
 * @property quotaCategory The quota type. Value:-CommonQuota (default): Generic quota.-FlowControl:API rate quota.-WhiteListLabel: Equity quota.
 */
public data class GetTemplateApplicationsResult(
    public val applications: List<GetTemplateApplicationsApplication>,
    public val batchQuotaApplicationId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val productCode: String? = null,
    public val quotaActionCode: String? = null,
    public val quotaCategory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetTemplateApplicationsResult): GetTemplateApplicationsResult = GetTemplateApplicationsResult(
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetTemplateApplicationsApplication.Companion.toKotlin(args0)
                })
            }),
            batchQuotaApplicationId = javaType.batchQuotaApplicationId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productCode = javaType.productCode().map({ args0 -> args0 }).orElse(null),
            quotaActionCode = javaType.quotaActionCode().map({ args0 -> args0 }).orElse(null),
            quotaCategory = javaType.quotaCategory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
