@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property aliyunUid Alibaba Cloud account (primary account).
 * @property applicationId The ID of the quota promotion request.
 * @property approveValue The approved quota value of the quota increase request.
 * @property auditReason Approval comments on quota increase applications.
 * @property dimensions Quota dimension. See `dimensions` below.
 * @property envLanguage The language of the quota application result notification. Value:
 * - zh (default): Chinese.
 * - en: English.
 * @property noticeType Whether to send notification of quota application result. Value:
 * - 0 (default): No.
 * - 3: Yes.
 * @property period Quota calculation period.
 * @property quotaArn Quota ARN.
 * @property quotaDescription The quota description.
 * @property quotaName The quota name.
 * @property quotaUnit Quota unit.
 * @property reason Reason for quota application.
 * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
 * @property status The approval status of the quota promotion application. Value:
 * - Disagree: reject.
 * - Approve: approved.
 * - Process: under review.
 * - Cancel: Closed.
 */
public data class TemplateApplicationsQuotaApplicationDetail(
    public val aliyunUid: String? = null,
    public val applicationId: String? = null,
    public val approveValue: Double? = null,
    public val auditReason: String? = null,
    public val dimensions: Map<String, String>? = null,
    public val envLanguage: String? = null,
    public val noticeType: Int? = null,
    public val period: TemplateApplicationsQuotaApplicationDetailPeriod? = null,
    public val quotaArn: String? = null,
    public val quotaDescription: String? = null,
    public val quotaName: String? = null,
    public val quotaUnit: String? = null,
    public val reason: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.TemplateApplicationsQuotaApplicationDetail): TemplateApplicationsQuotaApplicationDetail = TemplateApplicationsQuotaApplicationDetail(
            aliyunUid = javaType.aliyunUid().map({ args0 -> args0 }).orElse(null),
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            approveValue = javaType.approveValue().map({ args0 -> args0 }).orElse(null),
            auditReason = javaType.auditReason().map({ args0 -> args0 }).orElse(null),
            dimensions = javaType.dimensions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            envLanguage = javaType.envLanguage().map({ args0 -> args0 }).orElse(null),
            noticeType = javaType.noticeType().map({ args0 -> args0 }).orElse(null),
            period = javaType.period().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.TemplateApplicationsQuotaApplicationDetailPeriod.Companion.toKotlin(args0)
                })
            }).orElse(null),
            quotaArn = javaType.quotaArn().map({ args0 -> args0 }).orElse(null),
            quotaDescription = javaType.quotaDescription().map({ args0 -> args0 }).orElse(null),
            quotaName = javaType.quotaName().map({ args0 -> args0 }).orElse(null),
            quotaUnit = javaType.quotaUnit().map({ args0 -> args0 }).orElse(null),
            reason = javaType.reason().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
