@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountAlias].
 */
@PulumiTagMarker
public class AccountAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountAliasArgs = AccountAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountAliasArgsBuilder.() -> Unit) {
        val builder = AccountAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountAlias {
        val builtJavaResource = com.pulumi.alicloud.ram.AccountAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountAlias(builtJavaResource)
    }
}

/**
 * Provides a RAM cloud account alias.
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const alias = new alicloud.ram.AccountAlias("alias", {accountAlias: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * alias = alicloud.ram.AccountAlias("alias", account_alias=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @alias = new AliCloud.Ram.AccountAlias("alias", new()
 *     {
 *         Alias = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ram.NewAccountAlias(ctx, "alias", &ram.AccountAliasArgs{
 * 			AccountAlias: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.AccountAlias;
 * import com.pulumi.alicloud.ram.AccountAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var alias = new AccountAlias("alias", AccountAliasArgs.builder()
 *             .accountAlias(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   alias:
 *     type: alicloud:ram:AccountAlias
 *     properties:
 *       accountAlias: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM account alias can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/accountAlias:AccountAlias example my-alias
 * ```
 */
public class AccountAlias internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.AccountAlias,
) : KotlinCustomResource(javaResource, AccountAliasMapper) {
    /**
     * Alias of cloud account. This name can have a string of 3 to 32 characters, must contain only alphanumeric characters or hyphens, such as "-", and must not begin with a hyphen.
     */
    public val accountAlias: Output<String>
        get() = javaResource.accountAlias().applyValue({ args0 -> args0 })
}

public object AccountAliasMapper : ResourceMapper<AccountAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.AccountAlias::class == javaResource::class

    override fun map(javaResource: Resource): AccountAlias = AccountAlias(
        javaResource as
            com.pulumi.alicloud.ram.AccountAlias,
    )
}

/**
 * @see [AccountAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountAlias].
 */
public suspend fun accountAlias(
    name: String,
    block: suspend AccountAliasResourceBuilder.() -> Unit,
): AccountAlias {
    val builder = AccountAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountAlias(name: String): AccountAlias {
    val builder = AccountAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
