@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.AccountAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RAM cloud account alias.
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const alias = new alicloud.ram.AccountAlias("alias", {accountAlias: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * alias = alicloud.ram.AccountAlias("alias", account_alias=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @alias = new AliCloud.Ram.AccountAlias("alias", new()
 *     {
 *         Alias = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ram.NewAccountAlias(ctx, "alias", &ram.AccountAliasArgs{
 * 			AccountAlias: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.AccountAlias;
 * import com.pulumi.alicloud.ram.AccountAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var alias = new AccountAlias("alias", AccountAliasArgs.builder()
 *             .accountAlias(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   alias:
 *     type: alicloud:ram:AccountAlias
 *     properties:
 *       accountAlias: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM account alias can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/accountAlias:AccountAlias example my-alias
 * ```
 * @property accountAlias Alias of cloud account. This name can have a string of 3 to 32 characters, must contain only alphanumeric characters or hyphens, such as "-", and must not begin with a hyphen.
 */
public data class AccountAliasArgs(
    public val accountAlias: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.AccountAliasArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.AccountAliasArgs =
        com.pulumi.alicloud.ram.AccountAliasArgs.builder()
            .accountAlias(accountAlias?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountAliasArgs].
 */
@PulumiTagMarker
public class AccountAliasArgsBuilder internal constructor() {
    private var accountAlias: Output<String>? = null

    /**
     * @param value Alias of cloud account. This name can have a string of 3 to 32 characters, must contain only alphanumeric characters or hyphens, such as "-", and must not begin with a hyphen.
     */
    @JvmName("tcokffvjvaesfwjm")
    public suspend fun accountAlias(`value`: Output<String>) {
        this.accountAlias = value
    }

    /**
     * @param value Alias of cloud account. This name can have a string of 3 to 32 characters, must contain only alphanumeric characters or hyphens, such as "-", and must not begin with a hyphen.
     */
    @JvmName("onemrlexxpmokkbn")
    public suspend fun accountAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountAlias = mapped
    }

    internal fun build(): AccountAliasArgs = AccountAliasArgs(
        accountAlias = accountAlias,
    )
}
