@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountPasswordPolicy].
 */
@PulumiTagMarker
public class AccountPasswordPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountPasswordPolicyArgs = AccountPasswordPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountPasswordPolicyArgsBuilder.() -> Unit) {
        val builder = AccountPasswordPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountPasswordPolicy {
        val builtJavaResource = com.pulumi.alicloud.ram.AccountPasswordPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountPasswordPolicy(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Empty resource sets defaults values for every property.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ram.AccountPasswordPolicy("default", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ram.AccountPasswordPolicy("default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ram.AccountPasswordPolicy("default");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewAccountPasswordPolicy(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.AccountPasswordPolicy;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AccountPasswordPolicy("default");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ram:AccountPasswordPolicy
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const corporate = new alicloud.ram.AccountPasswordPolicy("corporate", {
 *     minimumPasswordLength: 9,
 *     requireLowercaseCharacters: false,
 *     requireUppercaseCharacters: false,
 *     requireNumbers: false,
 *     requireSymbols: false,
 *     hardExpiry: true,
 *     maxPasswordAge: 12,
 *     passwordReusePrevention: 5,
 *     maxLoginAttempts: 3,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * corporate = alicloud.ram.AccountPasswordPolicy("corporate",
 *     minimum_password_length=9,
 *     require_lowercase_characters=False,
 *     require_uppercase_characters=False,
 *     require_numbers=False,
 *     require_symbols=False,
 *     hard_expiry=True,
 *     max_password_age=12,
 *     password_reuse_prevention=5,
 *     max_login_attempts=3)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var corporate = new AliCloud.Ram.AccountPasswordPolicy("corporate", new()
 *     {
 *         MinimumPasswordLength = 9,
 *         RequireLowercaseCharacters = false,
 *         RequireUppercaseCharacters = false,
 *         RequireNumbers = false,
 *         RequireSymbols = false,
 *         HardExpiry = true,
 *         MaxPasswordAge = 12,
 *         PasswordReusePrevention = 5,
 *         MaxLoginAttempts = 3,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewAccountPasswordPolicy(ctx, "corporate", &ram.AccountPasswordPolicyArgs{
 * 			MinimumPasswordLength:      pulumi.Int(9),
 * 			RequireLowercaseCharacters: pulumi.Bool(false),
 * 			RequireUppercaseCharacters: pulumi.Bool(false),
 * 			RequireNumbers:             pulumi.Bool(false),
 * 			RequireSymbols:             pulumi.Bool(false),
 * 			HardExpiry:                 pulumi.Bool(true),
 * 			MaxPasswordAge:             pulumi.Int(12),
 * 			PasswordReusePrevention:    pulumi.Int(5),
 * 			MaxLoginAttempts:           pulumi.Int(3),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.AccountPasswordPolicy;
 * import com.pulumi.alicloud.ram.AccountPasswordPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var corporate = new AccountPasswordPolicy("corporate", AccountPasswordPolicyArgs.builder()
 *             .minimumPasswordLength(9)
 *             .requireLowercaseCharacters(false)
 *             .requireUppercaseCharacters(false)
 *             .requireNumbers(false)
 *             .requireSymbols(false)
 *             .hardExpiry(true)
 *             .maxPasswordAge(12)
 *             .passwordReusePrevention(5)
 *             .maxLoginAttempts(3)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   corporate:
 *     type: alicloud:ram:AccountPasswordPolicy
 *     properties:
 *       minimumPasswordLength: 9
 *       requireLowercaseCharacters: false
 *       requireUppercaseCharacters: false
 *       requireNumbers: false
 *       requireSymbols: false
 *       hardExpiry: true
 *       maxPasswordAge: 12
 *       passwordReusePrevention: 5
 *       maxLoginAttempts: 3
 * ```
 * <!--End PulumiCodeChooser -->
 * For not specified values sets defaults.
 * ## Import
 * RAM account password policy can be imported using the `id`, e.g.
 * bash
 * ```sh
 * $ pulumi import alicloud:ram/accountPasswordPolicy:AccountPasswordPolicy example ram-account-password-policy
 * ```
 */
public class AccountPasswordPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.AccountPasswordPolicy,
) : KotlinCustomResource(javaResource, AccountPasswordPolicyMapper) {
    /**
     * Specifies if a password can expire in a hard way. Default to false.
     */
    public val hardExpiry: Output<Boolean>?
        get() = javaResource.hardExpiry().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum logon attempts with an incorrect password within an hour. Valid value range: [0-32]. Default to 5.
     */
    public val maxLoginAttempts: Output<Int>?
        get() = javaResource.maxLoginAttempts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of days after which password expires. A value of 0 indicates that the password never expires. Valid value range: [0-1095]. Default to 0.
     */
    public val maxPasswordAge: Output<Int>?
        get() = javaResource.maxPasswordAge().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimal required length of password for a user. Valid value range: [8-32]. Default to 12.
     */
    public val minimumPasswordLength: Output<Int>?
        get() = javaResource.minimumPasswordLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User is not allowed to use the latest number of passwords specified in this parameter. A value of 0 indicates the password history check policy is disabled. Valid value range: [0-24]. Default to 0.
     */
    public val passwordReusePrevention: Output<Int>?
        get() = javaResource.passwordReusePrevention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if the occurrence of a lowercase character in the password is mandatory. Default to true.
     */
    public val requireLowercaseCharacters: Output<Boolean>?
        get() = javaResource.requireLowercaseCharacters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if the occurrence of a number in the password is mandatory. Default to true.
     */
    public val requireNumbers: Output<Boolean>?
        get() = javaResource.requireNumbers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if the occurrence of a special character in the password is mandatory. Default to true.
     */
    public val requireSymbols: Output<Boolean>?
        get() = javaResource.requireSymbols().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if the occurrence of an uppercase character in the password is mandatory. Default to true.
     */
    public val requireUppercaseCharacters: Output<Boolean>?
        get() = javaResource.requireUppercaseCharacters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AccountPasswordPolicyMapper : ResourceMapper<AccountPasswordPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.AccountPasswordPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccountPasswordPolicy =
        AccountPasswordPolicy(javaResource as com.pulumi.alicloud.ram.AccountPasswordPolicy)
}

/**
 * @see [AccountPasswordPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountPasswordPolicy].
 */
public suspend fun accountPasswordPolicy(
    name: String,
    block: suspend AccountPasswordPolicyResourceBuilder.() -> Unit,
): AccountPasswordPolicy {
    val builder = AccountPasswordPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountPasswordPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountPasswordPolicy(name: String): AccountPasswordPolicy {
    val builder = AccountPasswordPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
