@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.AccountPasswordPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Empty resource sets defaults values for every property.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ram.AccountPasswordPolicy("default", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ram.AccountPasswordPolicy("default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ram.AccountPasswordPolicy("default");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewAccountPasswordPolicy(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.AccountPasswordPolicy;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AccountPasswordPolicy("default");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ram:AccountPasswordPolicy
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const corporate = new alicloud.ram.AccountPasswordPolicy("corporate", {
 *     minimumPasswordLength: 9,
 *     requireLowercaseCharacters: false,
 *     requireUppercaseCharacters: false,
 *     requireNumbers: false,
 *     requireSymbols: false,
 *     hardExpiry: true,
 *     maxPasswordAge: 12,
 *     passwordReusePrevention: 5,
 *     maxLoginAttempts: 3,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * corporate = alicloud.ram.AccountPasswordPolicy("corporate",
 *     minimum_password_length=9,
 *     require_lowercase_characters=False,
 *     require_uppercase_characters=False,
 *     require_numbers=False,
 *     require_symbols=False,
 *     hard_expiry=True,
 *     max_password_age=12,
 *     password_reuse_prevention=5,
 *     max_login_attempts=3)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var corporate = new AliCloud.Ram.AccountPasswordPolicy("corporate", new()
 *     {
 *         MinimumPasswordLength = 9,
 *         RequireLowercaseCharacters = false,
 *         RequireUppercaseCharacters = false,
 *         RequireNumbers = false,
 *         RequireSymbols = false,
 *         HardExpiry = true,
 *         MaxPasswordAge = 12,
 *         PasswordReusePrevention = 5,
 *         MaxLoginAttempts = 3,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewAccountPasswordPolicy(ctx, "corporate", &ram.AccountPasswordPolicyArgs{
 * 			MinimumPasswordLength:      pulumi.Int(9),
 * 			RequireLowercaseCharacters: pulumi.Bool(false),
 * 			RequireUppercaseCharacters: pulumi.Bool(false),
 * 			RequireNumbers:             pulumi.Bool(false),
 * 			RequireSymbols:             pulumi.Bool(false),
 * 			HardExpiry:                 pulumi.Bool(true),
 * 			MaxPasswordAge:             pulumi.Int(12),
 * 			PasswordReusePrevention:    pulumi.Int(5),
 * 			MaxLoginAttempts:           pulumi.Int(3),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.AccountPasswordPolicy;
 * import com.pulumi.alicloud.ram.AccountPasswordPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var corporate = new AccountPasswordPolicy("corporate", AccountPasswordPolicyArgs.builder()
 *             .minimumPasswordLength(9)
 *             .requireLowercaseCharacters(false)
 *             .requireUppercaseCharacters(false)
 *             .requireNumbers(false)
 *             .requireSymbols(false)
 *             .hardExpiry(true)
 *             .maxPasswordAge(12)
 *             .passwordReusePrevention(5)
 *             .maxLoginAttempts(3)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   corporate:
 *     type: alicloud:ram:AccountPasswordPolicy
 *     properties:
 *       minimumPasswordLength: 9
 *       requireLowercaseCharacters: false
 *       requireUppercaseCharacters: false
 *       requireNumbers: false
 *       requireSymbols: false
 *       hardExpiry: true
 *       maxPasswordAge: 12
 *       passwordReusePrevention: 5
 *       maxLoginAttempts: 3
 * ```
 * <!--End PulumiCodeChooser -->
 * For not specified values sets defaults.
 * ## Import
 * RAM account password policy can be imported using the `id`, e.g.
 * bash
 * ```sh
 * $ pulumi import alicloud:ram/accountPasswordPolicy:AccountPasswordPolicy example ram-account-password-policy
 * ```
 * @property hardExpiry Specifies if a password can expire in a hard way. Default to false.
 * @property maxLoginAttempts Maximum logon attempts with an incorrect password within an hour. Valid value range: [0-32]. Default to 5.
 * @property maxPasswordAge The number of days after which password expires. A value of 0 indicates that the password never expires. Valid value range: [0-1095]. Default to 0.
 * @property minimumPasswordLength Minimal required length of password for a user. Valid value range: [8-32]. Default to 12.
 * @property passwordReusePrevention User is not allowed to use the latest number of passwords specified in this parameter. A value of 0 indicates the password history check policy is disabled. Valid value range: [0-24]. Default to 0.
 * @property requireLowercaseCharacters Specifies if the occurrence of a lowercase character in the password is mandatory. Default to true.
 * @property requireNumbers Specifies if the occurrence of a number in the password is mandatory. Default to true.
 * @property requireSymbols Specifies if the occurrence of a special character in the password is mandatory. Default to true.
 * @property requireUppercaseCharacters Specifies if the occurrence of an uppercase character in the password is mandatory. Default to true.
 */
public data class AccountPasswordPolicyArgs(
    public val hardExpiry: Output<Boolean>? = null,
    public val maxLoginAttempts: Output<Int>? = null,
    public val maxPasswordAge: Output<Int>? = null,
    public val minimumPasswordLength: Output<Int>? = null,
    public val passwordReusePrevention: Output<Int>? = null,
    public val requireLowercaseCharacters: Output<Boolean>? = null,
    public val requireNumbers: Output<Boolean>? = null,
    public val requireSymbols: Output<Boolean>? = null,
    public val requireUppercaseCharacters: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.AccountPasswordPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.AccountPasswordPolicyArgs =
        com.pulumi.alicloud.ram.AccountPasswordPolicyArgs.builder()
            .hardExpiry(hardExpiry?.applyValue({ args0 -> args0 }))
            .maxLoginAttempts(maxLoginAttempts?.applyValue({ args0 -> args0 }))
            .maxPasswordAge(maxPasswordAge?.applyValue({ args0 -> args0 }))
            .minimumPasswordLength(minimumPasswordLength?.applyValue({ args0 -> args0 }))
            .passwordReusePrevention(passwordReusePrevention?.applyValue({ args0 -> args0 }))
            .requireLowercaseCharacters(requireLowercaseCharacters?.applyValue({ args0 -> args0 }))
            .requireNumbers(requireNumbers?.applyValue({ args0 -> args0 }))
            .requireSymbols(requireSymbols?.applyValue({ args0 -> args0 }))
            .requireUppercaseCharacters(requireUppercaseCharacters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountPasswordPolicyArgs].
 */
@PulumiTagMarker
public class AccountPasswordPolicyArgsBuilder internal constructor() {
    private var hardExpiry: Output<Boolean>? = null

    private var maxLoginAttempts: Output<Int>? = null

    private var maxPasswordAge: Output<Int>? = null

    private var minimumPasswordLength: Output<Int>? = null

    private var passwordReusePrevention: Output<Int>? = null

    private var requireLowercaseCharacters: Output<Boolean>? = null

    private var requireNumbers: Output<Boolean>? = null

    private var requireSymbols: Output<Boolean>? = null

    private var requireUppercaseCharacters: Output<Boolean>? = null

    /**
     * @param value Specifies if a password can expire in a hard way. Default to false.
     */
    @JvmName("fbftxbjuirxinokf")
    public suspend fun hardExpiry(`value`: Output<Boolean>) {
        this.hardExpiry = value
    }

    /**
     * @param value Maximum logon attempts with an incorrect password within an hour. Valid value range: [0-32]. Default to 5.
     */
    @JvmName("ivvsiuhriwdkiona")
    public suspend fun maxLoginAttempts(`value`: Output<Int>) {
        this.maxLoginAttempts = value
    }

    /**
     * @param value The number of days after which password expires. A value of 0 indicates that the password never expires. Valid value range: [0-1095]. Default to 0.
     */
    @JvmName("rjqmunndyojyptdn")
    public suspend fun maxPasswordAge(`value`: Output<Int>) {
        this.maxPasswordAge = value
    }

    /**
     * @param value Minimal required length of password for a user. Valid value range: [8-32]. Default to 12.
     */
    @JvmName("mygjhsolxolkpopg")
    public suspend fun minimumPasswordLength(`value`: Output<Int>) {
        this.minimumPasswordLength = value
    }

    /**
     * @param value User is not allowed to use the latest number of passwords specified in this parameter. A value of 0 indicates the password history check policy is disabled. Valid value range: [0-24]. Default to 0.
     */
    @JvmName("usrwedsdtnomtdug")
    public suspend fun passwordReusePrevention(`value`: Output<Int>) {
        this.passwordReusePrevention = value
    }

    /**
     * @param value Specifies if the occurrence of a lowercase character in the password is mandatory. Default to true.
     */
    @JvmName("actjrgjcbkwaaynx")
    public suspend fun requireLowercaseCharacters(`value`: Output<Boolean>) {
        this.requireLowercaseCharacters = value
    }

    /**
     * @param value Specifies if the occurrence of a number in the password is mandatory. Default to true.
     */
    @JvmName("mprwnetetggxlwwq")
    public suspend fun requireNumbers(`value`: Output<Boolean>) {
        this.requireNumbers = value
    }

    /**
     * @param value Specifies if the occurrence of a special character in the password is mandatory. Default to true.
     */
    @JvmName("nbmwvgctbgwrtbuw")
    public suspend fun requireSymbols(`value`: Output<Boolean>) {
        this.requireSymbols = value
    }

    /**
     * @param value Specifies if the occurrence of an uppercase character in the password is mandatory. Default to true.
     */
    @JvmName("bntvgyjenqsdyraq")
    public suspend fun requireUppercaseCharacters(`value`: Output<Boolean>) {
        this.requireUppercaseCharacters = value
    }

    /**
     * @param value Specifies if a password can expire in a hard way. Default to false.
     */
    @JvmName("xdwrmcttfcdfcfbp")
    public suspend fun hardExpiry(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardExpiry = mapped
    }

    /**
     * @param value Maximum logon attempts with an incorrect password within an hour. Valid value range: [0-32]. Default to 5.
     */
    @JvmName("tphfibiogxidrqxj")
    public suspend fun maxLoginAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxLoginAttempts = mapped
    }

    /**
     * @param value The number of days after which password expires. A value of 0 indicates that the password never expires. Valid value range: [0-1095]. Default to 0.
     */
    @JvmName("xvfnqpuobhbyiedu")
    public suspend fun maxPasswordAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPasswordAge = mapped
    }

    /**
     * @param value Minimal required length of password for a user. Valid value range: [8-32]. Default to 12.
     */
    @JvmName("tilsrestjsyetprk")
    public suspend fun minimumPasswordLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumPasswordLength = mapped
    }

    /**
     * @param value User is not allowed to use the latest number of passwords specified in this parameter. A value of 0 indicates the password history check policy is disabled. Valid value range: [0-24]. Default to 0.
     */
    @JvmName("ntykcedumjkrlwsy")
    public suspend fun passwordReusePrevention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordReusePrevention = mapped
    }

    /**
     * @param value Specifies if the occurrence of a lowercase character in the password is mandatory. Default to true.
     */
    @JvmName("usjofbvknknyguxm")
    public suspend fun requireLowercaseCharacters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireLowercaseCharacters = mapped
    }

    /**
     * @param value Specifies if the occurrence of a number in the password is mandatory. Default to true.
     */
    @JvmName("xowpyhspvmqkrmcf")
    public suspend fun requireNumbers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireNumbers = mapped
    }

    /**
     * @param value Specifies if the occurrence of a special character in the password is mandatory. Default to true.
     */
    @JvmName("hyxfbjnhllfpmyhc")
    public suspend fun requireSymbols(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireSymbols = mapped
    }

    /**
     * @param value Specifies if the occurrence of an uppercase character in the password is mandatory. Default to true.
     */
    @JvmName("lmdmnhogschjyorw")
    public suspend fun requireUppercaseCharacters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireUppercaseCharacters = mapped
    }

    internal fun build(): AccountPasswordPolicyArgs = AccountPasswordPolicyArgs(
        hardExpiry = hardExpiry,
        maxLoginAttempts = maxLoginAttempts,
        maxPasswordAge = maxPasswordAge,
        minimumPasswordLength = minimumPasswordLength,
        passwordReusePrevention = passwordReusePrevention,
        requireLowercaseCharacters = requireLowercaseCharacters,
        requireNumbers = requireNumbers,
        requireSymbols = requireSymbols,
        requireUppercaseCharacters = requireUppercaseCharacters,
    )
}
