@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Alias].
 */
@PulumiTagMarker
public class AliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AliasArgs = AliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AliasArgsBuilder.() -> Unit) {
        val builder = AliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Alias {
        val builtJavaResource = com.pulumi.alicloud.ram.Alias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alias(builtJavaResource)
    }
}

public class Alias internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.Alias,
) : KotlinCustomResource(javaResource, AliasMapper) {
    public val accountAlias: Output<String>
        get() = javaResource.accountAlias().applyValue({ args0 -> args0 })
}

public object AliasMapper : ResourceMapper<Alias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.Alias::class == javaResource::class

    override fun map(javaResource: Resource): Alias = Alias(
        javaResource as
            com.pulumi.alicloud.ram.Alias,
    )
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alias].
 */
public suspend fun alias(name: String, block: suspend AliasResourceBuilder.() -> Unit): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alias(name: String): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
