@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RAM Group resource.
 * > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.
 * > **NOTE:** Available since v1.0.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new RAM Group.
 * const group = new alicloud.ram.Group("group", {
 *     name: "groupName",
 *     comments: "this is a group comments.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new RAM Group.
 * group = alicloud.ram.Group("group",
 *     name="groupName",
 *     comments="this is a group comments.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new RAM Group.
 *     var @group = new AliCloud.Ram.Group("group", new()
 *     {
 *         Name = "groupName",
 *         Comments = "this is a group comments.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new RAM Group.
 * 		_, err := ram.NewGroup(ctx, "group", &ram.GroupArgs{
 * 			Name:     pulumi.String("groupName"),
 * 			Comments: pulumi.String("this is a group comments."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.Group;
 * import com.pulumi.alicloud.ram.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new RAM Group.
 *         var group = new Group("group", GroupArgs.builder()
 *             .name("groupName")
 *             .comments("this is a group comments.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new RAM Group.
 *   group:
 *     type: alicloud:ram:Group
 *     properties:
 *       name: groupName
 *       comments: this is a group comments.
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM group can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/group:Group example my-group
 * ```
 * @property comments Comment of the RAM group. This parameter can have a string of 1 to 128 characters.
 * @property force This parameter is used for resource destroy. Default value is `false`.
 * @property name Name of the RAM group. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
 */
public data class GroupArgs(
    public val comments: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.GroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.GroupArgs =
        com.pulumi.alicloud.ram.GroupArgs.builder()
            .comments(comments?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var comments: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var name: Output<String>? = null

    /**
     * @param value Comment of the RAM group. This parameter can have a string of 1 to 128 characters.
     */
    @JvmName("tpxhkjredqdsdqmc")
    public suspend fun comments(`value`: Output<String>) {
        this.comments = value
    }

    /**
     * @param value This parameter is used for resource destroy. Default value is `false`.
     */
    @JvmName("ibbffalgqupmfjar")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value Name of the RAM group. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("fcwlyqukumkdiefc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Comment of the RAM group. This parameter can have a string of 1 to 128 characters.
     */
    @JvmName("rioserypxpcglwdu")
    public suspend fun comments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comments = mapped
    }

    /**
     * @param value This parameter is used for resource destroy. Default value is `false`.
     */
    @JvmName("qsdlitloycgjtvtt")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value Name of the RAM group. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("wnuoxmdshodjrjqn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        comments = comments,
        force = force,
        name = name,
    )
}
