@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GroupMembership].
 */
@PulumiTagMarker
public class GroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupMembershipArgs = GroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupMembershipArgsBuilder.() -> Unit) {
        val builder = GroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupMembership {
        val builtJavaResource = com.pulumi.alicloud.ram.GroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupMembership(builtJavaResource)
    }
}

/**
 * Provides a RAM Group membership resource.
 * > **NOTE:** Available since v1.0.0+.
 * ## Import
 * RAM Group membership can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/groupMembership:GroupMembership example my-group
 * ```
 */
public class GroupMembership internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.GroupMembership,
) : KotlinCustomResource(javaResource, GroupMembershipMapper) {
    /**
     * Name of the RAM group. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * Set of user name which will be added to group. Each name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    public val userNames: Output<List<String>>
        get() = javaResource.userNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object GroupMembershipMapper : ResourceMapper<GroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.GroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): GroupMembership = GroupMembership(
        javaResource as
            com.pulumi.alicloud.ram.GroupMembership,
    )
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupMembership].
 */
public suspend fun groupMembership(
    name: String,
    block: suspend GroupMembershipResourceBuilder.() -> Unit,
): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupMembership(name: String): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
