@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.GroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a RAM Group membership resource.
 * > **NOTE:** Available since v1.0.0+.
 * ## Import
 * RAM Group membership can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/groupMembership:GroupMembership example my-group
 * ```
 * @property groupName Name of the RAM group. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
 * @property userNames Set of user name which will be added to group. Each name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
 */
public data class GroupMembershipArgs(
    public val groupName: Output<String>? = null,
    public val userNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.GroupMembershipArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.GroupMembershipArgs =
        com.pulumi.alicloud.ram.GroupMembershipArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .userNames(userNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GroupMembershipArgs].
 */
@PulumiTagMarker
public class GroupMembershipArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var userNames: Output<List<String>>? = null

    /**
     * @param value Name of the RAM group. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("wrfrybmbevxlramv")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Set of user name which will be added to group. Each name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("haaivaagwmmupwgl")
    public suspend fun userNames(`value`: Output<List<String>>) {
        this.userNames = value
    }

    @JvmName("eqspiccccyuhxjgu")
    public suspend fun userNames(vararg values: Output<String>) {
        this.userNames = Output.all(values.asList())
    }

    /**
     * @param values Set of user name which will be added to group. Each name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("vsbfidumqdwgrjrl")
    public suspend fun userNames(values: List<Output<String>>) {
        this.userNames = Output.all(values)
    }

    /**
     * @param value Name of the RAM group. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("fnwnfmuxqcyuwltb")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Set of user name which will be added to group. Each name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("beaaiowqtbysnudx")
    public suspend fun userNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userNames = mapped
    }

    /**
     * @param values Set of user name which will be added to group. Each name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("tcondqndhaluoddt")
    public suspend fun userNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userNames = mapped
    }

    internal fun build(): GroupMembershipArgs = GroupMembershipArgs(
        groupName = groupName,
        userNames = userNames,
    )
}
