@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupPolicyAttachment].
 */
@PulumiTagMarker
public class GroupPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupPolicyAttachmentArgs = GroupPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = GroupPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupPolicyAttachment {
        val builtJavaResource = com.pulumi.alicloud.ram.GroupPolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupPolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides a RAM Group Policy attachment resource.
 * > **NOTE:** Available since v1.0.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * // Create a RAM Group Policy attachment.
 * const group = new alicloud.ram.Group("group", {
 *     name: "groupName",
 *     comments: "this is a group comments.",
 * });
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const policy = new alicloud.ram.Policy("policy", {
 *     policyName: `tf-example-${_default.result}`,
 *     policyDocument: `    {
 *       "Statement": [
 *         {
 *           "Action": [
 *             "oss:ListObjects",
 *             "oss:GetObject"
 *           ],
 *           "Effect": "Allow",
 *           "Resource": [
 *             "acs:oss:*:*:mybucket",
 *             "acs:oss:*:*:mybucket/*"
 *           ]
 *         }
 *       ],
 *         "Version": "1"
 *     }
 * `,
 *     description: "this is a policy test",
 * });
 * const attach = new alicloud.ram.GroupPolicyAttachment("attach", {
 *     policyName: policy.policyName,
 *     policyType: policy.type,
 *     groupName: group.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * # Create a RAM Group Policy attachment.
 * group = alicloud.ram.Group("group",
 *     name="groupName",
 *     comments="this is a group comments.")
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * policy = alicloud.ram.Policy("policy",
 *     policy_name=f"tf-example-{default['result']}",
 *     policy_document="""    {
 *       "Statement": [
 *         {
 *           "Action": [
 *             "oss:ListObjects",
 *             "oss:GetObject"
 *           ],
 *           "Effect": "Allow",
 *           "Resource": [
 *             "acs:oss:*:*:mybucket",
 *             "acs:oss:*:*:mybucket/*"
 *           ]
 *         }
 *       ],
 *         "Version": "1"
 *     }
 * """,
 *     description="this is a policy test")
 * attach = alicloud.ram.GroupPolicyAttachment("attach",
 *     policy_name=policy.policy_name,
 *     policy_type=policy.type,
 *     group_name=group.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a RAM Group Policy attachment.
 *     var @group = new AliCloud.Ram.Group("group", new()
 *     {
 *         Name = "groupName",
 *         Comments = "this is a group comments.",
 *     });
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var policy = new AliCloud.Ram.Policy("policy", new()
 *     {
 *         PolicyName = $"tf-example-{@default.Result}",
 *         PolicyDocument = @"    {
 *       ""Statement"": [
 *         {
 *           ""Action"": [
 *             ""oss:ListObjects"",
 *             ""oss:GetObject""
 *           ],
 *           ""Effect"": ""Allow"",
 *           ""Resource"": [
 *             ""acs:oss:*:*:mybucket"",
 *             ""acs:oss:*:*:mybucket/*""
 *           ]
 *         }
 *       ],
 *         ""Version"": ""1""
 *     }
 * ",
 *         Description = "this is a policy test",
 *     });
 *     var attach = new AliCloud.Ram.GroupPolicyAttachment("attach", new()
 *     {
 *         PolicyName = policy.PolicyName,
 *         PolicyType = policy.Type,
 *         GroupName = @group.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a RAM Group Policy attachment.
 * 		group, err := ram.NewGroup(ctx, "group", &ram.GroupArgs{
 * 			Name:     pulumi.String("groupName"),
 * 			Comments: pulumi.String("this is a group comments."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy, err := ram.NewPolicy(ctx, "policy", &ram.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			PolicyDocument: pulumi.String(`    {
 *       "Statement": [
 *         {
 *           "Action": [
 *             "oss:ListObjects",
 *             "oss:GetObject"
 *           ],
 *           "Effect": "Allow",
 *           "Resource": [
 *             "acs:oss:*:*:mybucket",
 *             "acs:oss:*:*:mybucket/*"
 *           ]
 *         }
 *       ],
 *         "Version": "1"
 *     }
 * `),
 * 			Description: pulumi.String("this is a policy test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewGroupPolicyAttachment(ctx, "attach", &ram.GroupPolicyAttachmentArgs{
 * 			PolicyName: policy.PolicyName,
 * 			PolicyType: policy.Type,
 * 			GroupName:  group.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.Group;
 * import com.pulumi.alicloud.ram.GroupArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ram.Policy;
 * import com.pulumi.alicloud.ram.PolicyArgs;
 * import com.pulumi.alicloud.ram.GroupPolicyAttachment;
 * import com.pulumi.alicloud.ram.GroupPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a RAM Group Policy attachment.
 *         var group = new Group("group", GroupArgs.builder()
 *             .name("groupName")
 *             .comments("this is a group comments.")
 *             .build());
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName(String.format("tf-example-%s", default_.result()))
 *             .policyDocument("""
 *     {
 *       "Statement": [
 *         {
 *           "Action": [
 *             "oss:ListObjects",
 *             "oss:GetObject"
 *           ],
 *           "Effect": "Allow",
 *           "Resource": [
 *             "acs:oss:*:*:mybucket",
 *             "acs:oss:*:*:mybucket/*"
 *           ]
 *         }
 *       ],
 *         "Version": "1"
 *     }
 *             """)
 *             .description("this is a policy test")
 *             .build());
 *         var attach = new GroupPolicyAttachment("attach", GroupPolicyAttachmentArgs.builder()
 *             .policyName(policy.policyName())
 *             .policyType(policy.type())
 *             .groupName(group.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a RAM Group Policy attachment.
 *   group:
 *     type: alicloud:ram:Group
 *     properties:
 *       name: groupName
 *       comments: this is a group comments.
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   policy:
 *     type: alicloud:ram:Policy
 *     properties:
 *       policyName: tf-example-${default.result}
 *       policyDocument: |2
 *             {
 *               "Statement": [
 *                 {
 *                   "Action": [
 *                     "oss:ListObjects",
 *                     "oss:GetObject"
 *                   ],
 *                   "Effect": "Allow",
 *                   "Resource": [
 *                     "acs:oss:*:*:mybucket",
 *                     "acs:oss:*:*:mybucket/*"
 *                   ]
 *                 }
 *               ],
 *                 "Version": "1"
 *             }
 *       description: this is a policy test
 *   attach:
 *     type: alicloud:ram:GroupPolicyAttachment
 *     properties:
 *       policyName: ${policy.policyName}
 *       policyType: ${policy.type}
 *       groupName: ${group.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM Group Policy attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/groupPolicyAttachment:GroupPolicyAttachment example group:my-policy:Custom:my-group
 * ```
 * */*/*/*/*/*/
 */
public class GroupPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.GroupPolicyAttachment,
) : KotlinCustomResource(javaResource, GroupPolicyAttachmentMapper) {
    /**
     * Name of the RAM group. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * Type of the RAM policy. It must be `Custom` or `System`.
     */
    public val policyType: Output<String>
        get() = javaResource.policyType().applyValue({ args0 -> args0 })
}

public object GroupPolicyAttachmentMapper : ResourceMapper<GroupPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.GroupPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): GroupPolicyAttachment =
        GroupPolicyAttachment(javaResource as com.pulumi.alicloud.ram.GroupPolicyAttachment)
}

/**
 * @see [GroupPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupPolicyAttachment].
 */
public suspend fun groupPolicyAttachment(
    name: String,
    block: suspend GroupPolicyAttachmentResourceBuilder.() -> Unit,
): GroupPolicyAttachment {
    val builder = GroupPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupPolicyAttachment(name: String): GroupPolicyAttachment {
    val builder = GroupPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
