@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LoginProfile].
 */
@PulumiTagMarker
public class LoginProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoginProfileArgs = LoginProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoginProfileArgsBuilder.() -> Unit) {
        val builder = LoginProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoginProfile {
        val builtJavaResource = com.pulumi.alicloud.ram.LoginProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoginProfile(builtJavaResource)
    }
}

/**
 * Provides a RAM User Login Profile resource.
 * For information about RAM User Login Profile and how to use it, see [What is Login Profile](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createloginprofile).
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const user = new alicloud.ram.User("user", {
 *     name: "terraform_example",
 *     displayName: "terraform_example",
 *     mobile: "86-18688888888",
 *     email: "hello.uuu@aaa.com",
 *     comments: "terraform_example",
 *     force: true,
 * });
 * const profile = new alicloud.ram.LoginProfile("profile", {
 *     userName: user.name,
 *     password: "Example_1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * user = alicloud.ram.User("user",
 *     name="terraform_example",
 *     display_name="terraform_example",
 *     mobile="86-18688888888",
 *     email="hello.uuu@aaa.com",
 *     comments="terraform_example",
 *     force=True)
 * profile = alicloud.ram.LoginProfile("profile",
 *     user_name=user.name,
 *     password="Example_1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AliCloud.Ram.User("user", new()
 *     {
 *         Name = "terraform_example",
 *         DisplayName = "terraform_example",
 *         Mobile = "86-18688888888",
 *         Email = "hello.uuu@aaa.com",
 *         Comments = "terraform_example",
 *         Force = true,
 *     });
 *     var profile = new AliCloud.Ram.LoginProfile("profile", new()
 *     {
 *         UserName = user.Name,
 *         Password = "Example_1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		user, err := ram.NewUser(ctx, "user", &ram.UserArgs{
 * 			Name:        pulumi.String("terraform_example"),
 * 			DisplayName: pulumi.String("terraform_example"),
 * 			Mobile:      pulumi.String("86-18688888888"),
 * 			Email:       pulumi.String("hello.uuu@aaa.com"),
 * 			Comments:    pulumi.String("terraform_example"),
 * 			Force:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewLoginProfile(ctx, "profile", &ram.LoginProfileArgs{
 * 			UserName: user.Name,
 * 			Password: pulumi.String("Example_1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import com.pulumi.alicloud.ram.LoginProfile;
 * import com.pulumi.alicloud.ram.LoginProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .name("terraform_example")
 *             .displayName("terraform_example")
 *             .mobile("86-18688888888")
 *             .email("hello.uuu@aaa.com")
 *             .comments("terraform_example")
 *             .force(true)
 *             .build());
 *         var profile = new LoginProfile("profile", LoginProfileArgs.builder()
 *             .userName(user.name())
 *             .password("Example_1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   user:
 *     type: alicloud:ram:User
 *     properties:
 *       name: terraform_example
 *       displayName: terraform_example
 *       mobile: 86-18688888888
 *       email: hello.uuu@aaa.com
 *       comments: terraform_example
 *       force: true
 *   profile:
 *     type: alicloud:ram:LoginProfile
 *     properties:
 *       userName: ${user.name}
 *       password: Example_1234
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM login profile can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/loginProfile:LoginProfile example <id>
 * ```
 */
public class LoginProfile internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.LoginProfile,
) : KotlinCustomResource(javaResource, LoginProfileMapper) {
    /**
     * Specifies whether an MFA device must be attached to the RAM user upon logon. Valid values: `true`, `false`. [To enhance the security of your resources and data, the default value has been changed to `true`](https://www.alibabacloud.com/en/notice/mfa20240524?_p_lc=1) .
     */
    public val mfaBindRequired: Output<Boolean>
        get() = javaResource.mfaBindRequired().applyValue({ args0 -> args0 })

    /**
     * The logon password of the RAM user. The password must meet the password strength requirements.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the RAM user must change the password upon logon. Default value: `false`. Valid values: `true`, `false`.
     */
    public val passwordResetRequired: Output<Boolean>?
        get() = javaResource.passwordResetRequired().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object LoginProfileMapper : ResourceMapper<LoginProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.LoginProfile::class == javaResource::class

    override fun map(javaResource: Resource): LoginProfile = LoginProfile(
        javaResource as
            com.pulumi.alicloud.ram.LoginProfile,
    )
}

/**
 * @see [LoginProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoginProfile].
 */
public suspend fun loginProfile(
    name: String,
    block: suspend LoginProfileResourceBuilder.() -> Unit,
): LoginProfile {
    val builder = LoginProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoginProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loginProfile(name: String): LoginProfile {
    val builder = LoginProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
