@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.LoginProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RAM User Login Profile resource.
 * For information about RAM User Login Profile and how to use it, see [What is Login Profile](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createloginprofile).
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const user = new alicloud.ram.User("user", {
 *     name: "terraform_example",
 *     displayName: "terraform_example",
 *     mobile: "86-18688888888",
 *     email: "hello.uuu@aaa.com",
 *     comments: "terraform_example",
 *     force: true,
 * });
 * const profile = new alicloud.ram.LoginProfile("profile", {
 *     userName: user.name,
 *     password: "Example_1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * user = alicloud.ram.User("user",
 *     name="terraform_example",
 *     display_name="terraform_example",
 *     mobile="86-18688888888",
 *     email="hello.uuu@aaa.com",
 *     comments="terraform_example",
 *     force=True)
 * profile = alicloud.ram.LoginProfile("profile",
 *     user_name=user.name,
 *     password="Example_1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AliCloud.Ram.User("user", new()
 *     {
 *         Name = "terraform_example",
 *         DisplayName = "terraform_example",
 *         Mobile = "86-18688888888",
 *         Email = "hello.uuu@aaa.com",
 *         Comments = "terraform_example",
 *         Force = true,
 *     });
 *     var profile = new AliCloud.Ram.LoginProfile("profile", new()
 *     {
 *         UserName = user.Name,
 *         Password = "Example_1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		user, err := ram.NewUser(ctx, "user", &ram.UserArgs{
 * 			Name:        pulumi.String("terraform_example"),
 * 			DisplayName: pulumi.String("terraform_example"),
 * 			Mobile:      pulumi.String("86-18688888888"),
 * 			Email:       pulumi.String("hello.uuu@aaa.com"),
 * 			Comments:    pulumi.String("terraform_example"),
 * 			Force:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewLoginProfile(ctx, "profile", &ram.LoginProfileArgs{
 * 			UserName: user.Name,
 * 			Password: pulumi.String("Example_1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import com.pulumi.alicloud.ram.LoginProfile;
 * import com.pulumi.alicloud.ram.LoginProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .name("terraform_example")
 *             .displayName("terraform_example")
 *             .mobile("86-18688888888")
 *             .email("hello.uuu@aaa.com")
 *             .comments("terraform_example")
 *             .force(true)
 *             .build());
 *         var profile = new LoginProfile("profile", LoginProfileArgs.builder()
 *             .userName(user.name())
 *             .password("Example_1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   user:
 *     type: alicloud:ram:User
 *     properties:
 *       name: terraform_example
 *       displayName: terraform_example
 *       mobile: 86-18688888888
 *       email: hello.uuu@aaa.com
 *       comments: terraform_example
 *       force: true
 *   profile:
 *     type: alicloud:ram:LoginProfile
 *     properties:
 *       userName: ${user.name}
 *       password: Example_1234
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM login profile can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/loginProfile:LoginProfile example <id>
 * ```
 * @property mfaBindRequired Specifies whether an MFA device must be attached to the RAM user upon logon. Valid values: `true`, `false`. [To enhance the security of your resources and data, the default value has been changed to `true`](https://www.alibabacloud.com/en/notice/mfa20240524?_p_lc=1) .
 * @property password The logon password of the RAM user. The password must meet the password strength requirements.
 * @property passwordResetRequired Specifies whether the RAM user must change the password upon logon. Default value: `false`. Valid values: `true`, `false`.
 * @property userName The name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
 */
public data class LoginProfileArgs(
    public val mfaBindRequired: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val passwordResetRequired: Output<Boolean>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.LoginProfileArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.LoginProfileArgs =
        com.pulumi.alicloud.ram.LoginProfileArgs.builder()
            .mfaBindRequired(mfaBindRequired?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .passwordResetRequired(passwordResetRequired?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoginProfileArgs].
 */
@PulumiTagMarker
public class LoginProfileArgsBuilder internal constructor() {
    private var mfaBindRequired: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var passwordResetRequired: Output<Boolean>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Specifies whether an MFA device must be attached to the RAM user upon logon. Valid values: `true`, `false`. [To enhance the security of your resources and data, the default value has been changed to `true`](https://www.alibabacloud.com/en/notice/mfa20240524?_p_lc=1) .
     */
    @JvmName("bjyywjimuctribig")
    public suspend fun mfaBindRequired(`value`: Output<Boolean>) {
        this.mfaBindRequired = value
    }

    /**
     * @param value The logon password of the RAM user. The password must meet the password strength requirements.
     */
    @JvmName("cdkwuikggylfxcxw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Specifies whether the RAM user must change the password upon logon. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("shxomvpbqnkwlxho")
    public suspend fun passwordResetRequired(`value`: Output<Boolean>) {
        this.passwordResetRequired = value
    }

    /**
     * @param value The name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("tjrptttqmnxawmty")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Specifies whether an MFA device must be attached to the RAM user upon logon. Valid values: `true`, `false`. [To enhance the security of your resources and data, the default value has been changed to `true`](https://www.alibabacloud.com/en/notice/mfa20240524?_p_lc=1) .
     */
    @JvmName("tjpnkvukjjnctugr")
    public suspend fun mfaBindRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaBindRequired = mapped
    }

    /**
     * @param value The logon password of the RAM user. The password must meet the password strength requirements.
     */
    @JvmName("niqvsrgfheiplqgq")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Specifies whether the RAM user must change the password upon logon. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("wggkhovtdwlijnpm")
    public suspend fun passwordResetRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordResetRequired = mapped
    }

    /**
     * @param value The name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("goawlvyyexneinkc")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): LoginProfileArgs = LoginProfileArgs(
        mfaBindRequired = mfaBindRequired,
        password = password,
        passwordResetRequired = passwordResetRequired,
        userName = userName,
    )
}
