@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.kotlin.outputs.PolicyStatement
import com.pulumi.alicloud.ram.kotlin.outputs.PolicyStatement.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.alicloud.ram.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides a RAM Policy resource.
 * > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.
 * > **NOTE:** Each policy can own at most 5 versions and the oldest version will be removed after its version achieves 5.
 * > **NOTE:** If the policy has multiple versions, all non-default versions will be deleted first when deleting policy.
 * > **NOTE:** Available since v1.0.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * // Create a new RAM Policy.
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const policy = new alicloud.ram.Policy("policy", {
 *     policyName: `tf-example-${_default.result}`,
 *     policyDocument: `  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `,
 *     description: "this is a policy test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * # Create a new RAM Policy.
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * policy = alicloud.ram.Policy("policy",
 *     policy_name=f"tf-example-{default['result']}",
 *     policy_document="""  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * """,
 *     description="this is a policy test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new RAM Policy.
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var policy = new AliCloud.Ram.Policy("policy", new()
 *     {
 *         PolicyName = $"tf-example-{@default.Result}",
 *         PolicyDocument = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": [
 *           ""oss:ListObjects"",
 *           ""oss:GetObject""
 *         ],
 *         ""Effect"": ""Allow"",
 *         ""Resource"": [
 *           ""acs:oss:*:*:mybucket"",
 *           ""acs:oss:*:*:mybucket/*""
 *         ]
 *       }
 *     ],
 *       ""Version"": ""1""
 *   }
 * ",
 *         Description = "this is a policy test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new RAM Policy.
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewPolicy(ctx, "policy", &ram.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			PolicyDocument: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `),
 * 			Description: pulumi.String("this is a policy test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ram.Policy;
 * import com.pulumi.alicloud.ram.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new RAM Policy.
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName(String.format("tf-example-%s", default_.result()))
 *             .policyDocument("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 *             """)
 *             .description("this is a policy test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new RAM Policy.
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   policy:
 *     type: alicloud:ram:Policy
 *     properties:
 *       policyName: tf-example-${default.result}
 *       policyDocument: |2
 *           {
 *             "Statement": [
 *               {
 *                 "Action": [
 *                   "oss:ListObjects",
 *                   "oss:GetObject"
 *                 ],
 *                 "Effect": "Allow",
 *                 "Resource": [
 *                   "acs:oss:*:*:mybucket",
 *                   "acs:oss:*:*:mybucket/*"
 *                 ]
 *               }
 *             ],
 *               "Version": "1"
 *           }
 *       description: this is a policy test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM policy can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/policy:Policy example my-policy
 * ```
 * */*/*/*/*/*/
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * The policy attachment count.
     */
    public val attachmentCount: Output<Int>
        get() = javaResource.attachmentCount().applyValue({ args0 -> args0 })

    /**
     * The default version of policy.
     */
    public val defaultVersion: Output<String>
        get() = javaResource.defaultVersion().applyValue({ args0 -> args0 })

    /**
     * Description of the RAM policy. This name can have a string of 1 to 1024 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * It has been deprecated since provider version 1.114.0 and `policy_document` instead.
     */
    @Deprecated(
        message = """
  Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document'
      instead.
  """,
    )
    public val document: Output<String>
        get() = javaResource.document().applyValue({ args0 -> args0 })

    /**
     * This parameter is used for resource destroy. Default value is `false`.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * It has been deprecated since provider version 1.114.0 and `policy_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Document of the RAM policy. It is required when the `statement` is not specified.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * The rotation strategy of the policy. You can use this parameter to delete an early policy version. Valid Values: `None`, `DeleteOldestNonDefaultVersionWhenLimitExceeded`. Default to `None`.
     */
    public val rotateStrategy: Output<String>
        get() = javaResource.rotateStrategy().applyValue({ args0 -> args0 })

    /**
     * (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val statements: Output<List<PolicyStatement>>
        get() = javaResource.statements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The policy type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM policy document. Valid value is `1`. Default value is `1`.
     */
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of default version policy.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.alicloud.ram.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
