@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.PolicyArgs.builder
import com.pulumi.alicloud.ram.kotlin.inputs.PolicyStatementArgs
import com.pulumi.alicloud.ram.kotlin.inputs.PolicyStatementArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a RAM Policy resource.
 * > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.
 * > **NOTE:** Each policy can own at most 5 versions and the oldest version will be removed after its version achieves 5.
 * > **NOTE:** If the policy has multiple versions, all non-default versions will be deleted first when deleting policy.
 * > **NOTE:** Available since v1.0.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * // Create a new RAM Policy.
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const policy = new alicloud.ram.Policy("policy", {
 *     policyName: `tf-example-${_default.result}`,
 *     policyDocument: `  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `,
 *     description: "this is a policy test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * # Create a new RAM Policy.
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * policy = alicloud.ram.Policy("policy",
 *     policy_name=f"tf-example-{default['result']}",
 *     policy_document="""  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * """,
 *     description="this is a policy test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new RAM Policy.
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var policy = new AliCloud.Ram.Policy("policy", new()
 *     {
 *         PolicyName = $"tf-example-{@default.Result}",
 *         PolicyDocument = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": [
 *           ""oss:ListObjects"",
 *           ""oss:GetObject""
 *         ],
 *         ""Effect"": ""Allow"",
 *         ""Resource"": [
 *           ""acs:oss:*:*:mybucket"",
 *           ""acs:oss:*:*:mybucket/*""
 *         ]
 *       }
 *     ],
 *       ""Version"": ""1""
 *   }
 * ",
 *         Description = "this is a policy test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new RAM Policy.
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewPolicy(ctx, "policy", &ram.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			PolicyDocument: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `),
 * 			Description: pulumi.String("this is a policy test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ram.Policy;
 * import com.pulumi.alicloud.ram.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new RAM Policy.
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName(String.format("tf-example-%s", default_.result()))
 *             .policyDocument("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 *             """)
 *             .description("this is a policy test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new RAM Policy.
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   policy:
 *     type: alicloud:ram:Policy
 *     properties:
 *       policyName: tf-example-${default.result}
 *       policyDocument: |2
 *           {
 *             "Statement": [
 *               {
 *                 "Action": [
 *                   "oss:ListObjects",
 *                   "oss:GetObject"
 *                 ],
 *                 "Effect": "Allow",
 *                 "Resource": [
 *                   "acs:oss:*:*:mybucket",
 *                   "acs:oss:*:*:mybucket/*"
 *                 ]
 *               }
 *             ],
 *               "Version": "1"
 *           }
 *       description: this is a policy test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM policy can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/policy:Policy example my-policy
 * ```
 * @property description Description of the RAM policy. This name can have a string of 1 to 1024 characters.
 * @property document It has been deprecated since provider version 1.114.0 and `policy_document` instead.
 * @property force This parameter is used for resource destroy. Default value is `false`.
 * @property name It has been deprecated since provider version 1.114.0 and `policy_name` instead.
 * @property policyDocument Document of the RAM policy. It is required when the `statement` is not specified.
 * @property policyName Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
 * @property rotateStrategy The rotation strategy of the policy. You can use this parameter to delete an early policy version. Valid Values: `None`, `DeleteOldestNonDefaultVersionWhenLimitExceeded`. Default to `None`.
 * @property statements (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
 * @property version (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM policy document. Valid value is `1`. Default value is `1`.
 * */*/*/*/*/*/
 */
public data class PolicyArgs(
    public val description: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document'
      instead.
  """,
    )
    public val document: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val rotateStrategy: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val statements: Output<List<PolicyStatementArgs>>? = null,
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.PolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.PolicyArgs =
        com.pulumi.alicloud.ram.PolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .document(document?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .rotateStrategy(rotateStrategy?.applyValue({ args0 -> args0 }))
            .statements(
                statements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var document: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var policyName: Output<String>? = null

    private var rotateStrategy: Output<String>? = null

    private var statements: Output<List<PolicyStatementArgs>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Description of the RAM policy. This name can have a string of 1 to 1024 characters.
     */
    @JvmName("etlxxabxfachvfhg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value It has been deprecated since provider version 1.114.0 and `policy_document` instead.
     */
    @Deprecated(
        message = """
  Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document'
      instead.
  """,
    )
    @JvmName("mmvhfueiuswyylda")
    public suspend fun document(`value`: Output<String>) {
        this.document = value
    }

    /**
     * @param value This parameter is used for resource destroy. Default value is `false`.
     */
    @JvmName("rqgyfjhkyqwitwgq")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value It has been deprecated since provider version 1.114.0 and `policy_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.
  """,
    )
    @JvmName("uhnqbnwrxjlxxibl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Document of the RAM policy. It is required when the `statement` is not specified.
     */
    @JvmName("xejlpwpkisifebvn")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("ihwgpgkiiycuogba")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The rotation strategy of the policy. You can use this parameter to delete an early policy version. Valid Values: `None`, `DeleteOldestNonDefaultVersionWhenLimitExceeded`. Default to `None`.
     */
    @JvmName("cxshprmlfvaktkak")
    public suspend fun rotateStrategy(`value`: Output<String>) {
        this.rotateStrategy = value
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("gauylfqacwhlosnr")
    public suspend fun statements(`value`: Output<List<PolicyStatementArgs>>) {
        this.statements = value
    }

    @JvmName("fbqutlohyyyuaslu")
    public suspend fun statements(vararg values: Output<PolicyStatementArgs>) {
        this.statements = Output.all(values.asList())
    }

    /**
     * @param values (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("ubcpnwqlbdtpyblr")
    public suspend fun statements(values: List<Output<PolicyStatementArgs>>) {
        this.statements = Output.all(values)
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM policy document. Valid value is `1`. Default value is `1`.
     */
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("ebpchxniywwdbmqh")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Description of the RAM policy. This name can have a string of 1 to 1024 characters.
     */
    @JvmName("vayygeqxwlexsjty")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value It has been deprecated since provider version 1.114.0 and `policy_document` instead.
     */
    @Deprecated(
        message = """
  Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document'
      instead.
  """,
    )
    @JvmName("frueqyfwsnmsrhyy")
    public suspend fun document(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.document = mapped
    }

    /**
     * @param value This parameter is used for resource destroy. Default value is `false`.
     */
    @JvmName("srqxeaehvefrpmfd")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value It has been deprecated since provider version 1.114.0 and `policy_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.
  """,
    )
    @JvmName("eptcoxjnssvdiilk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Document of the RAM policy. It is required when the `statement` is not specified.
     */
    @JvmName("algiwixvsxnaqokt")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("yoiqyjwoxxvpokry")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The rotation strategy of the policy. You can use this parameter to delete an early policy version. Valid Values: `None`, `DeleteOldestNonDefaultVersionWhenLimitExceeded`. Default to `None`.
     */
    @JvmName("xeuhliowgrgwtfvp")
    public suspend fun rotateStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotateStrategy = mapped
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("wficbqfkuxppmrun")
    public suspend fun statements(`value`: List<PolicyStatementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param argument (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("jsgfynalkoicnfwe")
    public suspend fun statements(argument: List<suspend PolicyStatementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("yjioewenrlvodpyf")
    public suspend fun statements(vararg argument: suspend PolicyStatementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("ldwerjuvvpdphcxe")
    public suspend fun statements(argument: suspend PolicyStatementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PolicyStatementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param values (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Statements of the RAM policy document. It is required when the `document` is not specified. See `statement` below.
     */
    @Deprecated(
        message = """
  Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("wffwpnvfxvjatbbe")
    public suspend fun statements(vararg values: PolicyStatementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM policy document. Valid value is `1`. Default value is `1`.
     */
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("qiyjqintrspgyehw")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        description = description,
        document = document,
        force = force,
        name = name,
        policyDocument = policyDocument,
        policyName = policyName,
        rotateStrategy = rotateStrategy,
        statements = statements,
        version = version,
    )
}
