@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.RamFunctions.getAccountAliasPlain
import com.pulumi.alicloud.ram.RamFunctions.getAccountAliasesPlain
import com.pulumi.alicloud.ram.RamFunctions.getGroupsPlain
import com.pulumi.alicloud.ram.RamFunctions.getPoliciesPlain
import com.pulumi.alicloud.ram.RamFunctions.getPolicyDocumentPlain
import com.pulumi.alicloud.ram.RamFunctions.getRolesPlain
import com.pulumi.alicloud.ram.RamFunctions.getSamlProvidersPlain
import com.pulumi.alicloud.ram.RamFunctions.getUsersPlain
import com.pulumi.alicloud.ram.kotlin.inputs.GetAccountAliasPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetAccountAliasPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.inputs.GetAccountAliasesPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetAccountAliasesPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.inputs.GetPoliciesPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetPoliciesPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.inputs.GetPolicyDocumentPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetPolicyDocumentPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.inputs.GetPolicyDocumentStatement
import com.pulumi.alicloud.ram.kotlin.inputs.GetRolesPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetRolesPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.inputs.GetSamlProvidersPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetSamlProvidersPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.alicloud.ram.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.alicloud.ram.kotlin.outputs.GetAccountAliasResult
import com.pulumi.alicloud.ram.kotlin.outputs.GetAccountAliasesResult
import com.pulumi.alicloud.ram.kotlin.outputs.GetGroupsResult
import com.pulumi.alicloud.ram.kotlin.outputs.GetPoliciesResult
import com.pulumi.alicloud.ram.kotlin.outputs.GetPolicyDocumentResult
import com.pulumi.alicloud.ram.kotlin.outputs.GetRolesResult
import com.pulumi.alicloud.ram.kotlin.outputs.GetSamlProvidersResult
import com.pulumi.alicloud.ram.kotlin.outputs.GetUsersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ram.kotlin.outputs.GetAccountAliasResult.Companion.toKotlin as getAccountAliasResultToKotlin
import com.pulumi.alicloud.ram.kotlin.outputs.GetAccountAliasesResult.Companion.toKotlin as getAccountAliasesResultToKotlin
import com.pulumi.alicloud.ram.kotlin.outputs.GetGroupsResult.Companion.toKotlin as getGroupsResultToKotlin
import com.pulumi.alicloud.ram.kotlin.outputs.GetPoliciesResult.Companion.toKotlin as getPoliciesResultToKotlin
import com.pulumi.alicloud.ram.kotlin.outputs.GetPolicyDocumentResult.Companion.toKotlin as getPolicyDocumentResultToKotlin
import com.pulumi.alicloud.ram.kotlin.outputs.GetRolesResult.Companion.toKotlin as getRolesResultToKotlin
import com.pulumi.alicloud.ram.kotlin.outputs.GetSamlProvidersResult.Companion.toKotlin as getSamlProvidersResultToKotlin
import com.pulumi.alicloud.ram.kotlin.outputs.GetUsersResult.Companion.toKotlin as getUsersResultToKotlin

public object RamFunctions {
    /**
     *
     * @param argument A collection of arguments for invoking getAccountAlias.
     * @return A collection of values returned by getAccountAlias.
     */
    public suspend fun getAccountAlias(argument: GetAccountAliasPlainArgs): GetAccountAliasResult =
        getAccountAliasResultToKotlin(getAccountAliasPlain(argument.toJava()).await())

    /**
     * @see [getAccountAlias].
     * @param outputFile
     * @return A collection of values returned by getAccountAlias.
     */
    public suspend fun getAccountAlias(outputFile: String? = null): GetAccountAliasResult {
        val argument = GetAccountAliasPlainArgs(
            outputFile = outputFile,
        )
        return getAccountAliasResultToKotlin(getAccountAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccountAlias].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetAccountAliasPlainArgs].
     * @return A collection of values returned by getAccountAlias.
     */
    public suspend fun getAccountAlias(argument: suspend GetAccountAliasPlainArgsBuilder.() -> Unit): GetAccountAliasResult {
        val builder = GetAccountAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountAliasResultToKotlin(getAccountAliasPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getAccountAliases.
     * @return A collection of values returned by getAccountAliases.
     */
    public suspend fun getAccountAliases(argument: GetAccountAliasesPlainArgs): GetAccountAliasesResult =
        getAccountAliasesResultToKotlin(getAccountAliasesPlain(argument.toJava()).await())

    /**
     * @see [getAccountAliases].
     * @param outputFile
     * @return A collection of values returned by getAccountAliases.
     */
    public suspend fun getAccountAliases(outputFile: String? = null): GetAccountAliasesResult {
        val argument = GetAccountAliasesPlainArgs(
            outputFile = outputFile,
        )
        return getAccountAliasesResultToKotlin(getAccountAliasesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccountAliases].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetAccountAliasesPlainArgs].
     * @return A collection of values returned by getAccountAliases.
     */
    public suspend fun getAccountAliases(argument: suspend GetAccountAliasesPlainArgsBuilder.() -> Unit): GetAccountAliasesResult {
        val builder = GetAccountAliasesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountAliasesResultToKotlin(getAccountAliasesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of RAM Groups in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available since v1.0.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const groupsDs = alicloud.ram.getGroups({
     *     outputFile: "groups.txt",
     *     userName: "user1",
     *     nameRegex: "^group[0-9]*",
     * });
     * export const firstGroupName = groupsDs.then(groupsDs => groupsDs.groups?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * groups_ds = alicloud.ram.get_groups(output_file="groups.txt",
     *     user_name="user1",
     *     name_regex="^group[0-9]*")
     * pulumi.export("firstGroupName", groups_ds.groups[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var groupsDs = AliCloud.Ram.GetGroups.Invoke(new()
     *     {
     *         OutputFile = "groups.txt",
     *         UserName = "user1",
     *         NameRegex = "^group[0-9]*",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGroupName"] = groupsDs&#46;Apply(getGroupsResult => getGroupsResult&#46;Groups[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		groupsDs, err := ram.GetGroups(ctx, &ram.GetGroupsArgs{
     * 			OutputFile: pulumi.StringRef("groups.txt"),
     * 			UserName:   pulumi.StringRef("user1"),
     * 			NameRegex:  pulumi.StringRef("^group[0-9]*"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGroupName", groupsDs.Groups[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var groupsDs = RamFunctions.getGroups(GetGroupsArgs.builder()
     *             .outputFile("groups.txt")
     *             .userName("user1")
     *             .nameRegex("^group[0-9]*")
     *             .build());
     *         ctx.export("firstGroupName", groupsDs.applyValue(getGroupsResult -> getGroupsResult.groups()[0].name()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   groupsDs:
     *     fn::invoke:
     *       Function: alicloud:ram:getGroups
     *       Arguments:
     *         outputFile: groups.txt
     *         userName: user1
     *         nameRegex: ^group[0-9]*
     * outputs:
     *   firstGroupName: ${groupsDs.groups[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param nameRegex A regex string to filter the returned groups by their names.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyName Filter the results by a specific policy name. If you set this parameter without setting `policy_type`, it will be automatically set to `System`.
     * @param policyType Filter the results by a specific policy type. Valid items are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
     * @param userName Filter the results by a specific the user name.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(
        nameRegex: String? = null,
        outputFile: String? = null,
        policyName: String? = null,
        policyType: String? = null,
        userName: String? = null,
    ): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            nameRegex = nameRegex,
            outputFile = outputFile,
            policyName = policyName,
            policyType = policyType,
            userName = userName,
        )
        return getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsResultToKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of RAM policies in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available since v1.0.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const policiesDs = alicloud.ram.getPolicies({
     *     outputFile: "policies.txt",
     *     userName: "user1",
     *     groupName: "group1",
     *     type: "System",
     * });
     * export const firstPolicyName = policiesDs.then(policiesDs => policiesDs.policies?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * policies_ds = alicloud.ram.get_policies(output_file="policies.txt",
     *     user_name="user1",
     *     group_name="group1",
     *     type="System")
     * pulumi.export("firstPolicyName", policies_ds.policies[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var policiesDs = AliCloud.Ram.GetPolicies.Invoke(new()
     *     {
     *         OutputFile = "policies.txt",
     *         UserName = "user1",
     *         GroupName = "group1",
     *         Type = "System",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPolicyName"] = policiesDs&#46;Apply(getPoliciesResult => getPoliciesResult&#46;Policies[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		policiesDs, err := ram.GetPolicies(ctx, &ram.GetPoliciesArgs{
     * 			OutputFile: pulumi.StringRef("policies.txt"),
     * 			UserName:   pulumi.StringRef("user1"),
     * 			GroupName:  pulumi.StringRef("group1"),
     * 			Type:       pulumi.StringRef("System"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPolicyName", policiesDs.Policies[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var policiesDs = RamFunctions.getPolicies(GetPoliciesArgs.builder()
     *             .outputFile("policies.txt")
     *             .userName("user1")
     *             .groupName("group1")
     *             .type("System")
     *             .build());
     *         ctx.export("firstPolicyName", policiesDs.applyValue(getPoliciesResult -> getPoliciesResult.policies()[0].name()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   policiesDs:
     *     fn::invoke:
     *       Function: alicloud:ram:getPolicies
     *       Arguments:
     *         outputFile: policies.txt
     *         userName: user1
     *         groupName: group1
     *         type: System
     * outputs:
     *   firstPolicyName: ${policiesDs.policies[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPolicies.
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(argument: GetPoliciesPlainArgs): GetPoliciesResult =
        getPoliciesResultToKotlin(getPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getPolicies].
     * @param enableDetails Default to `true`. Set it to true can output more details.
     * @param groupName Filter results by a specific group name. Returned policies are attached to the specified group.
     * @param ids A list of ram group IDs.
     * @param nameRegex A regex string to filter resulting policies by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param roleName Filter results by a specific role name. Returned policies are attached to the specified role.
     * @param type Filter results by a specific policy type. Valid values are `Custom` and `System`.
     * @param userName Filter results by a specific user name. Returned policies are attached to the specified user.
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(
        enableDetails: Boolean? = null,
        groupName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        roleName: String? = null,
        type: String? = null,
        userName: String? = null,
    ): GetPoliciesResult {
        val argument = GetPoliciesPlainArgs(
            enableDetails = enableDetails,
            groupName = groupName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            roleName = roleName,
            type = type,
            userName = userName,
        )
        return getPoliciesResultToKotlin(getPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetPoliciesPlainArgs].
     * @return A collection of values returned by getPolicies.
     */
    public suspend fun getPolicies(argument: suspend GetPoliciesPlainArgsBuilder.() -> Unit): GetPoliciesResult {
        val builder = GetPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoliciesResultToKotlin(getPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source Generates a RAM policy document of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.184.0+.
     * ## Example Usage
     * ### Basic Example
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const basicExample = alicloud.ram.getPolicyDocument({
     *     version: "1",
     *     statements: [{
     *         effect: "Allow",
     *         actions: ["oss:*"],
     *         resources: [
     *             "acs:oss:*:*:myphotos",
     *             "acs:oss:*:*:myphotos/*",
     *         ],
     *     }],
     * });
     * const _default = new alicloud.ram.Policy("default", {
     *     policyName: "tf-example",
     *     policyDocument: basicExample.then(basicExample => basicExample.document),
     *     force: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * basic_example = alicloud.ram.get_policy_document(version="1",
     *     statements=[{
     *         "effect": "Allow",
     *         "actions": ["oss:*"],
     *         "resources": [
     *             "acs:oss:*:*:myphotos",
     *             "acs:oss:*:*:myphotos/*",
     *         ],
     *     }])
     * default = alicloud.ram.Policy("default",
     *     policy_name="tf-example",
     *     policy_document=basic_example.document,
     *     force=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var basicExample = AliCloud.Ram.GetPolicyDocument.Invoke(new()
     *     {
     *         Version = "1",
     *         Statements = new[]
     *         {
     *             new AliCloud.Ram.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "oss:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "acs:oss:*:*:myphotos",
     *                     "acs:oss:*:*:myphotos/*",
     *                 },
     *             },
     *         },
     *     });
     *     var @default = new AliCloud.Ram.Policy("default", new()
     *     {
     *         PolicyName = "tf-example",
     *         PolicyDocument = basicExample.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Document),
     *         Force = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		basicExample, err := ram.GetPolicyDocument(ctx, &ram.GetPolicyDocumentArgs{
     * 			Version: pulumi.StringRef("1"),
     * 			Statements: []ram.GetPolicyDocumentStatement{
     * 				{
     * 					Effect: pulumi.StringRef("Allow"),
     * 					Actions: []string{
     * 						"oss:*",
     * 					},
     * 					Resources: []string{
     * 						"acs:oss:*:*:myphotos",
     * 						"acs:oss:*:*:myphotos/*",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ram.NewPolicy(ctx, "default", &ram.PolicyArgs{
     * 			PolicyName:     pulumi.String("tf-example"),
     * 			PolicyDocument: pulumi.String(basicExample.Document),
     * 			Force:          pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.alicloud.ram.Policy;
     * import com.pulumi.alicloud.ram.PolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var basicExample = RamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .version("1")
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions("oss:*")
     *                 .resources(
     *                     "acs:oss:*:*:myphotos",
     *                     "acs:oss:*:*:myphotos/*")
     *                 .build())
     *             .build());
     *         var default_ = new Policy("default", PolicyArgs.builder()
     *             .policyName("tf-example")
     *             .policyDocument(basicExample.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.document()))
     *             .force(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:ram:Policy
     *     properties:
     *       policyName: tf-example
     *       policyDocument: ${basicExample.document}
     *       force: true
     * variables:
     *   basicExample:
     *     fn::invoke:
     *       Function: alicloud:ram:getPolicyDocument
     *       Arguments:
     *         version: '1'
     *         statements:
     *           - effect: Allow
     *             actions:
     *               - oss:*
     *             resources:
     *               - acs:oss:*:*:myphotos
     *               - acs:oss:*:*:myphotos/*
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.alicloud_ram_policy_document.basic_example.document` will evaluate to:
     * ```json
     * {
     *   "Statement": [
     *     {
     *       "Effect": "Allow",
     *       "Action": "oss:*",
     *       "Resource": [
     *         "acs:oss:*:*:myphotos",
     *         "acs:oss:*:*:myphotos/*"
     *       ]
     *     }
     *   ],
     *   "Version": "1"
     * }
     * ```
     * ### Example Multiple Condition Keys and Values
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const multipleCondition = alicloud.ram.getPolicyDocument({
     *     version: "1",
     *     statements: [
     *         {
     *             effect: "Allow",
     *             actions: [
     *                 "oss:ListBuckets",
     *                 "oss:GetBucketStat",
     *                 "oss:GetBucketInfo",
     *                 "oss:GetBucketTagging",
     *                 "oss:GetBucketAcl",
     *             ],
     *             resources: ["acs:oss:*:*:*"],
     *         },
     *         {
     *             effect: "Allow",
     *             actions: [
     *                 "oss:GetObject",
     *                 "oss:GetObjectAcl",
     *             ],
     *             resources: ["acs:oss:*:*:myphotos/hangzhou/2015/*"],
     *         },
     *         {
     *             effect: "Allow",
     *             actions: ["oss:ListObjects"],
     *             resources: ["acs:oss:*:*:myphotos"],
     *             conditions: [
     *                 {
     *                     operator: "StringLike",
     *                     variable: "oss:Delimiter",
     *                     values: ["/"],
     *                 },
     *                 {
     *                     operator: "StringLike",
     *                     variable: "oss:Prefix",
     *                     values: [
     *                         "",
     *                         "hangzhou/",
     *                         "hangzhou/2015/*",
     *                     ],
     *                 },
     *             ],
     *         },
     *     ],
     * });
     * const policy = new alicloud.ram.Policy("policy", {
     *     policyName: "tf-example-condition",
     *     policyDocument: multipleCondition.then(multipleCondition => multipleCondition.document),
     *     force: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * multiple_condition = alicloud.ram.get_policy_document(version="1",
     *     statements=[
     *         {
     *             "effect": "Allow",
     *             "actions": [
     *                 "oss:ListBuckets",
     *                 "oss:GetBucketStat",
     *                 "oss:GetBucketInfo",
     *                 "oss:GetBucketTagging",
     *                 "oss:GetBucketAcl",
     *             ],
     *             "resources": ["acs:oss:*:*:*"],
     *         },
     *         {
     *             "effect": "Allow",
     *             "actions": [
     *                 "oss:GetObject",
     *                 "oss:GetObjectAcl",
     *             ],
     *             "resources": ["acs:oss:*:*:myphotos/hangzhou/2015/*"],
     *         },
     *         {
     *             "effect": "Allow",
     *             "actions": ["oss:ListObjects"],
     *             "resources": ["acs:oss:*:*:myphotos"],
     *             "conditions": [
     *                 {
     *                     "operator": "StringLike",
     *                     "variable": "oss:Delimiter",
     *                     "values": ["/"],
     *                 },
     *                 {
     *                     "operator": "StringLike",
     *                     "variable": "oss:Prefix",
     *                     "values": [
     *                         "",
     *                         "hangzhou/",
     *                         "hangzhou/2015/*",
     *                     ],
     *                 },
     *             ],
     *         },
     *     ])
     * policy = alicloud.ram.Policy("policy",
     *     policy_name="tf-example-condition",
     *     policy_document=multiple_condition.document,
     *     force=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var multipleCondition = AliCloud.Ram.GetPolicyDocument.Invoke(new()
     *     {
     *         Version = "1",
     *         Statements = new[]
     *         {
     *             new AliCloud.Ram.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "oss:ListBuckets",
     *                     "oss:GetBucketStat",
     *                     "oss:GetBucketInfo",
     *                     "oss:GetBucketTagging",
     *                     "oss:GetBucketAcl",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "acs:oss:*:*:*",
     *                 },
     *             },
     *             new AliCloud.Ram.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "oss:GetObject",
     *                     "oss:GetObjectAcl",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "acs:oss:*:*:myphotos/hangzhou/2015/*",
     *                 },
     *             },
     *             new AliCloud.Ram.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "oss:ListObjects",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "acs:oss:*:*:myphotos",
     *                 },
     *                 Conditions = new[]
     *                 {
     *                     new AliCloud.Ram.Inputs.GetPolicyDocumentStatementConditionInputArgs
     *                     {
     *                         Operator = "StringLike",
     *                         Variable = "oss:Delimiter",
     *                         Values = new[]
     *                         {
     *                             "/",
     *                         },
     *                     },
     *                     new AliCloud.Ram.Inputs.GetPolicyDocumentStatementConditionInputArgs
     *                     {
     *                         Operator = "StringLike",
     *                         Variable = "oss:Prefix",
     *                         Values = new[]
     *                         {
     *                             "",
     *                             "hangzhou/",
     *                             "hangzhou/2015/*",
     *                         },
     *                     },
     *                 },
     *             },
     *         },
     *     });
     *     var policy = new AliCloud.Ram.Policy("policy", new()
     *     {
     *         PolicyName = "tf-example-condition",
     *         PolicyDocument = multipleCondition.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Document),
     *         Force = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		multipleCondition, err := ram.GetPolicyDocument(ctx, &ram.GetPolicyDocumentArgs{
     * 			Version: pulumi.StringRef("1"),
     * 			Statements: []ram.GetPolicyDocumentStatement{
     * 				{
     * 					Effect: pulumi.StringRef("Allow"),
     * 					Actions: []string{
     * 						"oss:ListBuckets",
     * 						"oss:GetBucketStat",
     * 						"oss:GetBucketInfo",
     * 						"oss:GetBucketTagging",
     * 						"oss:GetBucketAcl",
     * 					},
     * 					Resources: []string{
     * 						"acs:oss:*:*:*",
     * 					},
     * 				},
     * 				{
     * 					Effect: pulumi.StringRef("Allow"),
     * 					Actions: []string{
     * 						"oss:GetObject",
     * 						"oss:GetObjectAcl",
     * 					},
     * 					Resources: []string{
     * 						"acs:oss:*:*:myphotos/hangzhou/2015/*",
     * 					},
     * 				},
     * 				{
     * 					Effect: pulumi.StringRef("Allow"),
     * 					Actions: []string{
     * 						"oss:ListObjects",
     * 					},
     * 					Resources: []string{
     * 						"acs:oss:*:*:myphotos",
     * 					},
     * 					Conditions: []ram.GetPolicyDocumentStatementCondition{
     * 						{
     * 							Operator: "StringLike",
     * 							Variable: "oss:Delimiter",
     * 							Values: []string{
     * 								"/",
     * 							},
     * 						},
     * 						{
     * 							Operator: "StringLike",
     * 							Variable: "oss:Prefix",
     * 							Values: []string{
     * 								"",
     * 								"hangzhou/",
     * 								"hangzhou/2015/*",
     * 							},
     * 						},
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ram.NewPolicy(ctx, "policy", &ram.PolicyArgs{
     * 			PolicyName:     pulumi.String("tf-example-condition"),
     * 			PolicyDocument: pulumi.String(multipleCondition.Document),
     * 			Force:          pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.alicloud.ram.Policy;
     * import com.pulumi.alicloud.ram.PolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var multipleCondition = RamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .version("1")
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .actions(
     *                         "oss:ListBuckets",
     *                         "oss:GetBucketStat",
     *                         "oss:GetBucketInfo",
     *                         "oss:GetBucketTagging",
     *                         "oss:GetBucketAcl")
     *                     .resources("acs:oss:*:*:*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .actions(
     *                         "oss:GetObject",
     *                         "oss:GetObjectAcl")
     *                     .resources("acs:oss:*:*:myphotos/hangzhou/2015/*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .actions("oss:ListObjects")
     *                     .resources("acs:oss:*:*:myphotos")
     *                     .conditions(
     *                         GetPolicyDocumentStatementConditionArgs.builder()
     *                             .operator("StringLike")
     *                             .variable("oss:Delimiter")
     *                             .values("/")
     *                             .build(),
     *                         GetPolicyDocumentStatementConditionArgs.builder()
     *                             .operator("StringLike")
     *                             .variable("oss:Prefix")
     *                             .values(
     *                                 "",
     *                                 "hangzhou/",
     *                                 "hangzhou/2015/*")
     *                             .build())
     *                     .build())
     *             .build());
     *         var policy = new Policy("policy", PolicyArgs.builder()
     *             .policyName("tf-example-condition")
     *             .policyDocument(multipleCondition.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.document()))
     *             .force(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   policy:
     *     type: alicloud:ram:Policy
     *     properties:
     *       policyName: tf-example-condition
     *       policyDocument: ${multipleCondition.document}
     *       force: true
     * variables:
     *   multipleCondition:
     *     fn::invoke:
     *       Function: alicloud:ram:getPolicyDocument
     *       Arguments:
     *         version: '1'
     *         statements:
     *           - effect: Allow
     *             actions:
     *               - oss:ListBuckets
     *               - oss:GetBucketStat
     *               - oss:GetBucketInfo
     *               - oss:GetBucketTagging
     *               - oss:GetBucketAcl
     *             resources:
     *               - acs:oss:*:*:*
     *           - effect: Allow
     *             actions:
     *               - oss:GetObject
     *               - oss:GetObjectAcl
     *             resources:
     *               - acs:oss:*:*:myphotos/hangzhou/2015/*
     *           - effect: Allow
     *             actions:
     *               - oss:ListObjects
     *             resources:
     *               - acs:oss:*:*:myphotos
     *             conditions:
     *               - operator: StringLike
     *                 variable: oss:Delimiter
     *                 values:
     *                   - /
     *               - operator: StringLike
     *                 variable: oss:Prefix
     *                 values:
     *                   -
     *                   - hangzhou/
     *                   - hangzhou/2015/*
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.alicloud_ram_policy_document.multiple_condition.document` will evaluate to:
     * ```json
     * {
     *   "Statement": [
     *     {
     *       "Effect": "Allow",
     *       "Action": [
     *         "oss:ListBuckets",
     *         "oss:GetBucketStat",
     *         "oss:GetBucketInfo",
     *         "oss:GetBucketTagging",
     *         "oss:GetBucketAcl"
     *       ],
     *       "Resource": "acs:oss:*:*:*"
     *     },
     *     {
     *       "Effect": "Allow",
     *       "Action": [
     *         "oss:GetObject",
     *         "oss:GetObjectAcl"
     *       ],
     *       "Resource": "acs:oss:*:*:myphotos/hangzhou/2015/*"
     *     },
     *     {
     *       "Effect": "Allow",
     *       "Action": "oss:ListObjects",
     *       "Resource": "acs:oss:*:*:myphotos",
     *       "Condition": {
     *         "StringLike": {
     *           "oss:Delimiter": "/",
     *           "oss:Prefix": [
     *             "",
     *             "hangzhou/",
     *             "hangzhou/2015/*"
     *           ]
     *         }
     *       }
     *     }
     *   ],
     *   "Version": "1"
     * }
     * ```
     * ### Example Assume-Role Policy with RAM Principal
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ramExample = alicloud.ram.getPolicyDocument({
     *     statements: [{
     *         effect: "Allow",
     *         actions: ["sts:AssumeRole"],
     *         principals: [{
     *             entity: "RAM",
     *             identifiers: ["acs:ram::123456789012****:root"],
     *         }],
     *     }],
     * });
     * const role = new alicloud.ram.Role("role", {
     *     name: "tf-example-role-ram",
     *     document: ramExample.then(ramExample => ramExample.document),
     *     force: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ram_example = alicloud.ram.get_policy_document(statements=[{
     *     "effect": "Allow",
     *     "actions": ["sts:AssumeRole"],
     *     "principals": [{
     *         "entity": "RAM",
     *         "identifiers": ["acs:ram::123456789012****:root"],
     *     }],
     * }])
     * role = alicloud.ram.Role("role",
     *     name="tf-example-role-ram",
     *     document=ram_example.document,
     *     force=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ramExample = AliCloud.Ram.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new AliCloud.Ram.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "sts:AssumeRole",
     *                 },
     *                 Principals = new[]
     *                 {
     *                     new AliCloud.Ram.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Entity = "RAM",
     *                         Identifiers = new[]
     *                         {
     *                             "acs:ram::123456789012****:root",
     *                         },
     *                     },
     *                 },
     *             },
     *         },
     *     });
     *     var role = new AliCloud.Ram.Role("role", new()
     *     {
     *         Name = "tf-example-role-ram",
     *         Document = ramExample.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Document),
     *         Force = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ramExample, err := ram.GetPolicyDocument(ctx, &ram.GetPolicyDocumentArgs{
     * 			Statements: []ram.GetPolicyDocumentStatement{
     * 				{
     * 					Effect: pulumi.StringRef("Allow"),
     * 					Actions: []string{
     * 						"sts:AssumeRole",
     * 					},
     * 					Principals: []ram.GetPolicyDocumentStatementPrincipal{
     * 						{
     * 							Entity: "RAM",
     * 							Identifiers: []string{
     * 								"acs:ram::123456789012****:root",
     * 							},
     * 						},
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ram.NewRole(ctx, "role", &ram.RoleArgs{
     * 			Name:     pulumi.String("tf-example-role-ram"),
     * 			Document: pulumi.String(ramExample.Document),
     * 			Force:    pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.alicloud.ram.Role;
     * import com.pulumi.alicloud.ram.RoleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ramExample = RamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions("sts:AssumeRole")
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .entity("RAM")
     *                     .identifiers("acs:ram::123456789012****:root")
     *                     .build())
     *                 .build())
     *             .build());
     *         var role = new Role("role", RoleArgs.builder()
     *             .name("tf-example-role-ram")
     *             .document(ramExample.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.document()))
     *             .force(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   role:
     *     type: alicloud:ram:Role
     *     properties:
     *       name: tf-example-role-ram
     *       document: ${ramExample.document}
     *       force: true
     * variables:
     *   ramExample:
     *     fn::invoke:
     *       Function: alicloud:ram:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - effect: Allow
     *             actions:
     *               - sts:AssumeRole
     *             principals:
     *               - entity: RAM
     *                 identifiers:
     *                   - acs:ram::123456789012****:root
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.alicloud_ram_policy_document.ram_example.document` will evaluate to:
     * ```json
     * {
     *   "Statement": [
     *     {
     *       "Effect": "Allow",
     *       "Action": "sts:AssumeRole",
     *       "Principal": {
     *         "RAM": [
     *           "acs:ram::123456789012****:root"
     *         ]
     *       }
     *     }
     *   ],
     *   "Version": "1"
     * }
     * ```
     * ### Example Assume-Role Policy with Service Principal
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const serviceExample = alicloud.ram.getPolicyDocument({
     *     statements: [{
     *         effect: "Allow",
     *         actions: ["sts:AssumeRole"],
     *         principals: [{
     *             entity: "Service",
     *             identifiers: ["ecs&#46;aliyuncs&#46;com"],
     *         }],
     *     }],
     * });
     * const role = new alicloud.ram.Role("role", {
     *     name: "tf-example-role-service",
     *     document: serviceExample.then(serviceExample => serviceExample.document),
     *     force: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * service_example = alicloud.ram.get_policy_document(statements=[{
     *     "effect": "Allow",
     *     "actions": ["sts:AssumeRole"],
     *     "principals": [{
     *         "entity": "Service",
     *         "identifiers": ["ecs&#46;aliyuncs&#46;com"],
     *     }],
     * }])
     * role = alicloud.ram.Role("role",
     *     name="tf-example-role-service",
     *     document=service_example.document,
     *     force=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var serviceExample = AliCloud.Ram.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new AliCloud.Ram.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "sts:AssumeRole",
     *                 },
     *                 Principals = new[]
     *                 {
     *                     new AliCloud.Ram.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Entity = "Service",
     *                         Identifiers = new[]
     *                         {
     *                             "ecs.aliyuncs.com",
     *                         },
     *                     },
     *                 },
     *             },
     *         },
     *     });
     *     var role = new AliCloud.Ram.Role("role", new()
     *     {
     *         Name = "tf-example-role-service",
     *         Document = serviceExample.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Document),
     *         Force = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		serviceExample, err := ram.GetPolicyDocument(ctx, &ram.GetPolicyDocumentArgs{
     * 			Statements: []ram.GetPolicyDocumentStatement{
     * 				{
     * 					Effect: pulumi.StringRef("Allow"),
     * 					Actions: []string{
     * 						"sts:AssumeRole",
     * 					},
     * 					Principals: []ram.GetPolicyDocumentStatementPrincipal{
     * 						{
     * 							Entity: "Service",
     * 							Identifiers: []string{
     * 								"ecs.aliyuncs.com",
     * 							},
     * 						},
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ram.NewRole(ctx, "role", &ram.RoleArgs{
     * 			Name:     pulumi.String("tf-example-role-service"),
     * 			Document: pulumi.String(serviceExample.Document),
     * 			Force:    pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.alicloud.ram.Role;
     * import com.pulumi.alicloud.ram.RoleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var serviceExample = RamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions("sts:AssumeRole")
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .entity("Service")
     *                     .identifiers("ecs.aliyuncs.com")
     *                     .build())
     *                 .build())
     *             .build());
     *         var role = new Role("role", RoleArgs.builder()
     *             .name("tf-example-role-service")
     *             .document(serviceExample.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.document()))
     *             .force(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   role:
     *     type: alicloud:ram:Role
     *     properties:
     *       name: tf-example-role-service
     *       document: ${serviceExample.document}
     *       force: true
     * variables:
     *   serviceExample:
     *     fn::invoke:
     *       Function: alicloud:ram:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - effect: Allow
     *             actions:
     *               - sts:AssumeRole
     *             principals:
     *               - entity: Service
     *                 identifiers:
     *                   - ecs.aliyuncs.com
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.alicloud_ram_policy_document.service_example.document` will evaluate to:
     * ```json
     * {
     *   "Statement": [
     *     {
     *       "Effect": "Allow",
     *       "Action": "sts:AssumeRole",
     *       "Principal": {
     *         "Service": [
     *           "ecs.aliyuncs.com"
     *         ]
     *       }
     *     }
     *   ],
     *   "Version": "1"
     * }
     * ```
     * ### Example Assume-Role Policy with Federated Principal
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const federatedExample = alicloud.ram.getPolicyDocument({
     *     statements: [{
     *         effect: "Allow",
     *         actions: ["sts:AssumeRole"],
     *         principals: [{
     *             entity: "Federated",
     *             identifiers: ["acs:ram::123456789012****:saml-provider/testprovider"],
     *         }],
     *         conditions: [{
     *             operator: "StringEquals",
     *             variable: "saml:recipient",
     *             values: ["https://signin&#46;aliyun&#46;com/saml-role/sso"],
     *         }],
     *     }],
     * });
     * const role = new alicloud.ram.Role("role", {
     *     name: "tf-example-role-federated",
     *     document: federatedExample.then(federatedExample => federatedExample.document),
     *     force: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * federated_example = alicloud.ram.get_policy_document(statements=[{
     *     "effect": "Allow",
     *     "actions": ["sts:AssumeRole"],
     *     "principals": [{
     *         "entity": "Federated",
     *         "identifiers": ["acs:ram::123456789012****:saml-provider/testprovider"],
     *     }],
     *     "conditions": [{
     *         "operator": "StringEquals",
     *         "variable": "saml:recipient",
     *         "values": ["https://signin&#46;aliyun&#46;com/saml-role/sso"],
     *     }],
     * }])
     * role = alicloud.ram.Role("role",
     *     name="tf-example-role-federated",
     *     document=federated_example.document,
     *     force=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var federatedExample = AliCloud.Ram.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new AliCloud.Ram.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "sts:AssumeRole",
     *                 },
     *                 Principals = new[]
     *                 {
     *                     new AliCloud.Ram.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Entity = "Federated",
     *                         Identifiers = new[]
     *                         {
     *                             "acs:ram::123456789012****:saml-provider/testprovider",
     *                         },
     *                     },
     *                 },
     *                 Conditions = new[]
     *                 {
     *                     new AliCloud.Ram.Inputs.GetPolicyDocumentStatementConditionInputArgs
     *                     {
     *                         Operator = "StringEquals",
     *                         Variable = "saml:recipient",
     *                         Values = new[]
     *                         {
     *                             "https://signin.aliyun.com/saml-role/sso",
     *                         },
     *                     },
     *                 },
     *             },
     *         },
     *     });
     *     var role = new AliCloud.Ram.Role("role", new()
     *     {
     *         Name = "tf-example-role-federated",
     *         Document = federatedExample.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Document),
     *         Force = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		federatedExample, err := ram.GetPolicyDocument(ctx, &ram.GetPolicyDocumentArgs{
     * 			Statements: []ram.GetPolicyDocumentStatement{
     * 				{
     * 					Effect: pulumi.StringRef("Allow"),
     * 					Actions: []string{
     * 						"sts:AssumeRole",
     * 					},
     * 					Principals: []ram.GetPolicyDocumentStatementPrincipal{
     * 						{
     * 							Entity: "Federated",
     * 							Identifiers: []string{
     * 								"acs:ram::123456789012****:saml-provider/testprovider",
     * 							},
     * 						},
     * 					},
     * 					Conditions: []ram.GetPolicyDocumentStatementCondition{
     * 						{
     * 							Operator: "StringEquals",
     * 							Variable: "saml:recipient",
     * 							Values: []string{
     * 								"https://signin.aliyun.com/saml-role/sso",
     * 							},
     * 						},
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ram.NewRole(ctx, "role", &ram.RoleArgs{
     * 			Name:     pulumi.String("tf-example-role-federated"),
     * 			Document: pulumi.String(federatedExample.Document),
     * 			Force:    pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.alicloud.ram.Role;
     * import com.pulumi.alicloud.ram.RoleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var federatedExample = RamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .effect("Allow")
     *                 .actions("sts:AssumeRole")
     *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                     .entity("Federated")
     *                     .identifiers("acs:ram::123456789012****:saml-provider/testprovider")
     *                     .build())
     *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
     *                     .operator("StringEquals")
     *                     .variable("saml:recipient")
     *                     .values("https://signin.aliyun.com/saml-role/sso")
     *                     .build())
     *                 .build())
     *             .build());
     *         var role = new Role("role", RoleArgs.builder()
     *             .name("tf-example-role-federated")
     *             .document(federatedExample.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.document()))
     *             .force(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   role:
     *     type: alicloud:ram:Role
     *     properties:
     *       name: tf-example-role-federated
     *       document: ${federatedExample.document}
     *       force: true
     * variables:
     *   federatedExample:
     *     fn::invoke:
     *       Function: alicloud:ram:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - effect: Allow
     *             actions:
     *               - sts:AssumeRole
     *             principals:
     *               - entity: Federated
     *                 identifiers:
     *                   - acs:ram::123456789012****:saml-provider/testprovider
     *             conditions:
     *               - operator: StringEquals
     *                 variable: saml:recipient
     *                 values:
     *                   - https://signin.aliyun.com/saml-role/sso
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.alicloud_ram_policy_document.federated_example.document` will evaluate to:
     * ```json
     * {
     *   "Statement": [
     *     {
     *       "Effect": "Allow",
     *       "Action": "sts:AssumeRole",
     *       "Principal": {
     *         "Federated": [
     *           "acs:ram::123456789012****:saml-provider/testprovider"
     *         ]
     *       },
     *       "Condition": {
     *         "StringEquals": {
     *           "saml:recipient": "https://signin.aliyun.com/saml-role/sso"
     *         }
     *       }
     *     }
     *   ],
     *   "Version": "1"
     * }
     * ```
     * @param argument A collection of arguments for invoking getPolicyDocument.
     * @return A collection of values returned by getPolicyDocument.
     * */*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
     */
    public suspend fun getPolicyDocument(argument: GetPolicyDocumentPlainArgs): GetPolicyDocumentResult =
        getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getPolicyDocument].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param statements Statement of the RAM policy document. See the following `Block statement`. See `statement` below.
     * @param version Version of the RAM policy document. Valid value is `1`. Default value is `1`.
     * @return A collection of values returned by getPolicyDocument.
     */
    public suspend fun getPolicyDocument(
        outputFile: String? = null,
        statements: List<GetPolicyDocumentStatement>? = null,
        version: String? = null,
    ): GetPolicyDocumentResult {
        val argument = GetPolicyDocumentPlainArgs(
            outputFile = outputFile,
            statements = statements,
            version = version,
        )
        return getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetPolicyDocumentPlainArgs].
     * @return A collection of values returned by getPolicyDocument.
     */
    public suspend fun getPolicyDocument(argument: suspend GetPolicyDocumentPlainArgsBuilder.() -> Unit): GetPolicyDocumentResult {
        val builder = GetPolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of RAM Roles in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available since v1.0.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const rolesDs = alicloud.ram.getRoles({
     *     outputFile: "roles.txt",
     *     nameRegex: ".*test.*",
     *     policyName: "AliyunACSDefaultAccess",
     *     policyType: "Custom",
     * });
     * export const firstRoleId = rolesDs.then(rolesDs => rolesDs.roles?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * roles_ds = alicloud.ram.get_roles(output_file="roles.txt",
     *     name_regex=".*test.*",
     *     policy_name="AliyunACSDefaultAccess",
     *     policy_type="Custom")
     * pulumi.export("firstRoleId", roles_ds.roles[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var rolesDs = AliCloud.Ram.GetRoles.Invoke(new()
     *     {
     *         OutputFile = "roles.txt",
     *         NameRegex = ".*test.*",
     *         PolicyName = "AliyunACSDefaultAccess",
     *         PolicyType = "Custom",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRoleId"] = rolesDs&#46;Apply(getRolesResult => getRolesResult&#46;Roles[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		rolesDs, err := ram.GetRoles(ctx, &ram.GetRolesArgs{
     * 			OutputFile: pulumi.StringRef("roles.txt"),
     * 			NameRegex:  pulumi.StringRef(".*test.*"),
     * 			PolicyName: pulumi.StringRef("AliyunACSDefaultAccess"),
     * 			PolicyType: pulumi.StringRef("Custom"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRoleId", rolesDs.Roles[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var rolesDs = RamFunctions.getRoles(GetRolesArgs.builder()
     *             .outputFile("roles.txt")
     *             .nameRegex(".*test.*")
     *             .policyName("AliyunACSDefaultAccess")
     *             .policyType("Custom")
     *             .build());
     *         ctx.export("firstRoleId", rolesDs.applyValue(getRolesResult -> getRolesResult.roles()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   rolesDs:
     *     fn::invoke:
     *       Function: alicloud:ram:getRoles
     *       Arguments:
     *         outputFile: roles.txt
     *         nameRegex: .*test.*
     *         policyName: AliyunACSDefaultAccess
     *         policyType: Custom
     * outputs:
     *   firstRoleId: ${rolesDs.roles[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRoles.
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: GetRolesPlainArgs): GetRolesResult =
        getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())

    /**
     * @see [getRoles].
     * @param ids A list of ram role IDs.
     * @param nameRegex A regex string to filter results by the role name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyName Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. The resulting roles will be attached to the specified policy.
     * @param policyType Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        policyName: String? = null,
        policyType: String? = null,
    ): GetRolesResult {
        val argument = GetRolesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            policyName = policyName,
            policyType = policyType,
        )
        return getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoles].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetRolesPlainArgs].
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: suspend GetRolesPlainArgsBuilder.() -> Unit): GetRolesResult {
        val builder = GetRolesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRolesResultToKotlin(getRolesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ram Saml Providers of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.114.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ram.getSamlProviders({
     *     ids: ["samlProviderName"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const firstRamSamlProviderId = example.then(example => example.providers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ram.get_saml_providers(ids=["samlProviderName"],
     *     name_regex="tf-testAcc")
     * pulumi.export("firstRamSamlProviderId", example.providers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ram.GetSamlProviders.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "samlProviderName",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRamSamlProviderId"] = example&#46;Apply(getSamlProvidersResult => getSamlProvidersResult&#46;Providers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ram.GetSamlProviders(ctx, &ram.GetSamlProvidersArgs{
     * 			Ids: []string{
     * 				"samlProviderName",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRamSamlProviderId", example.Providers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetSamlProvidersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RamFunctions.getSamlProviders(GetSamlProvidersArgs.builder()
     *             .ids("samlProviderName")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("firstRamSamlProviderId", example.applyValue(getSamlProvidersResult -> getSamlProvidersResult.providers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ram:getSamlProviders
     *       Arguments:
     *         ids:
     *           - samlProviderName
     *         nameRegex: tf-testAcc
     * outputs:
     *   firstRamSamlProviderId: ${example.providers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSamlProviders.
     * @return A collection of values returned by getSamlProviders.
     */
    public suspend fun getSamlProviders(argument: GetSamlProvidersPlainArgs): GetSamlProvidersResult =
        getSamlProvidersResultToKotlin(getSamlProvidersPlain(argument.toJava()).await())

    /**
     * @see [getSamlProviders].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of SAML Provider IDs.
     * @param nameRegex A regex string to filter results by SAML Provider name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getSamlProviders.
     */
    public suspend fun getSamlProviders(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetSamlProvidersResult {
        val argument = GetSamlProvidersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getSamlProvidersResultToKotlin(getSamlProvidersPlain(argument.toJava()).await())
    }

    /**
     * @see [getSamlProviders].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetSamlProvidersPlainArgs].
     * @return A collection of values returned by getSamlProviders.
     */
    public suspend fun getSamlProviders(argument: suspend GetSamlProvidersPlainArgsBuilder.() -> Unit): GetSamlProvidersResult {
        val builder = GetSamlProvidersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSamlProvidersResultToKotlin(getSamlProvidersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of RAM users in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available since v1.0.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.ram.Group("default", {
     *     name: "group1",
     *     comments: "group comments",
     *     force: true,
     * });
     * const defaultUser = new alicloud.ram.User("default", {
     *     name: "user-example",
     *     displayName: "displayname",
     *     mobile: "86-18888888888",
     *     email: "hello.uuu@aaa.com",
     *     comments: "yoyoyo",
     * });
     * const defaultGroupMembership = new alicloud.ram.GroupMembership("default", {
     *     groupName: _default.name,
     *     userNames: [defaultUser&#46;name],
     * });
     * const defaultPolicy = new alicloud.ram.Policy("default", {
     *     policyName: "ram-policy-example",
     *     policyDocument: `\x09\x09\x09{
     * \x09\x09\x09\x09"Statement": [
     * \x09\x09\x09\x09 {
     * \x09\x09\x09\x09\x09"Action": [
     * \x09\x09\x09\x09\x09"oss:ListObjects",
     * \x09\x09\x09\x09\x09"oss:ListObjects"
     * \x09\x09\x09  \x09\x09],
     * \x09\x09\x09  \x09\x09"Effect": "Deny",
     * \x09\x09\x09  \x09\x09"Resource": [
     * \x09\x09\x09\x09\x09\x09"acs:oss:*:*:mybucket",
     * \x09\x09\x09\x09\x09\x09"acs:oss:*:*:mybucket/*"
     * \x09\x09\x09  \x09\x09]
     * \x09\x09\x09\x09 }
     * \x09\x09  \x09\x09],
     * \x09\x09\x09\x09"Version": "1"
     * \x09\x09\x09}
     * `,
     *     description: "this is a policy example",
     *     force: true,
     * });
     * const defaultUserPolicyAttachment = new alicloud.ram.UserPolicyAttachment("default", {
     *     policyName: defaultPolicy.policyName,
     *     userName: defaultUser.name,
     *     policyType: defaultPolicy.type,
     * });
     * const usersDs = alicloud.ram.getUsersOutput({
     *     outputFile: "users.txt",
     *     groupName: _default.name,
     *     policyName: defaultPolicy.policyName,
     *     policyType: "Custom",
     *     nameRegex: defaultUser.name,
     * });
     * export const firstUserId = usersDs.apply(usersDs => usersDs.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ram.Group("default",
     *     name="group1",
     *     comments="group comments",
     *     force=True)
     * default_user = alicloud.ram.User("default",
     *     name="user-example",
     *     display_name="displayname",
     *     mobile="86-18888888888",
     *     email="hello.uuu@aaa.com",
     *     comments="yoyoyo")
     * default_group_membership = alicloud.ram.GroupMembership("default",
     *     group_name=default.name,
     *     user_names=[default_user&#46;name])
     * default_policy = alicloud.ram.Policy("default",
     *     policy_name="ram-policy-example",
     *     policy_document="""\x09\x09\x09{
     * \x09\x09\x09\x09"Statement": [
     * \x09\x09\x09\x09 {
     * \x09\x09\x09\x09\x09"Action": [
     * \x09\x09\x09\x09\x09"oss:ListObjects",
     * \x09\x09\x09\x09\x09"oss:ListObjects"
     * \x09\x09\x09  \x09\x09],
     * \x09\x09\x09  \x09\x09"Effect": "Deny",
     * \x09\x09\x09  \x09\x09"Resource": [
     * \x09\x09\x09\x09\x09\x09"acs:oss:*:*:mybucket",
     * \x09\x09\x09\x09\x09\x09"acs:oss:*:*:mybucket/*"
     * \x09\x09\x09  \x09\x09]
     * \x09\x09\x09\x09 }
     * \x09\x09  \x09\x09],
     * \x09\x09\x09\x09"Version": "1"
     * \x09\x09\x09}
     * """,
     *     description="this is a policy example",
     *     force=True)
     * default_user_policy_attachment = alicloud.ram.UserPolicyAttachment("default",
     *     policy_name=default_policy.policy_name,
     *     user_name=default_user.name,
     *     policy_type=default_policy.type)
     * users_ds = alicloud.ram.get_users_output(output_file="users.txt",
     *     group_name=default.name,
     *     policy_name=default_policy.policy_name,
     *     policy_type="Custom",
     *     name_regex=default_user.name)
     * pulumi.export("firstUserId", users_ds.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.Ram.Group("default", new()
     *     {
     *         Name = "group1",
     *         Comments = "group comments",
     *         Force = true,
     *     });
     *     var defaultUser = new AliCloud.Ram.User("default", new()
     *     {
     *         Name = "user-example",
     *         DisplayName = "displayname",
     *         Mobile = "86-18888888888",
     *         Email = "hello.uuu@aaa.com",
     *         Comments = "yoyoyo",
     *     });
     *     var defaultGroupMembership = new AliCloud.Ram.GroupMembership("default", new()
     *     {
     *         GroupName = @default.Name,
     *         UserNames = new[]
     *         {
     *             defaultUser.Name,
     *         },
     *     });
     *     var defaultPolicy = new AliCloud.Ram.Policy("default", new()
     *     {
     *         PolicyName = "ram-policy-example",
     *         PolicyDocument = @"			{
     * 				""Statement"": [
     * 				 {
     * 					""Action"": [
     * 					""oss:ListObjects"",
     * 					""oss:ListObjects""
     * 			  		],
     * 			  		""Effect"": ""Deny"",
     * 			  		""Resource"": [
     * 						""acs:oss:*:*:mybucket"",
     * 						""acs:oss:*:*:mybucket/*""
     * 			  		]
     * 				 }
     * 		  		],
     * 				""Version"": ""1""
     * 			}
     * ",
     *         Description = "this is a policy example",
     *         Force = true,
     *     });
     *     var defaultUserPolicyAttachment = new AliCloud.Ram.UserPolicyAttachment("default", new()
     *     {
     *         PolicyName = defaultPolicy.PolicyName,
     *         UserName = defaultUser.Name,
     *         PolicyType = defaultPolicy.Type,
     *     });
     *     var usersDs = AliCloud.Ram.GetUsers.Invoke(new()
     *     {
     *         OutputFile = "users.txt",
     *         GroupName = @default.Name,
     *         PolicyName = defaultPolicy.PolicyName,
     *         PolicyType = "Custom",
     *         NameRegex = defaultUser.Name,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstUserId"] = usersDs&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ram.NewGroup(ctx, "default", &ram.GroupArgs{
     * 			Name:     pulumi.String("group1"),
     * 			Comments: pulumi.String("group comments"),
     * 			Force:    pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultUser, err := ram.NewUser(ctx, "default", &ram.UserArgs{
     * 			Name:        pulumi.String("user-example"),
     * 			DisplayName: pulumi.String("displayname"),
     * 			Mobile:      pulumi.String("86-18888888888"),
     * 			Email:       pulumi.String("hello.uuu@aaa.com"),
     * 			Comments:    pulumi.String("yoyoyo"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ram.NewGroupMembership(ctx, "default", &ram.GroupMembershipArgs{
     * 			GroupName: _default.Name,
     * 			UserNames: pulumi.StringArray{
     * 				defaultUser.Name,
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultPolicy, err := ram.NewPolicy(ctx, "default", &ram.PolicyArgs{
     * 			PolicyName: pulumi.String("ram-policy-example"),
     * 			PolicyDocument: pulumi.String(`			{
     * 				"Statement": [
     * 				 {
     * 					"Action": [
     * 					"oss:ListObjects",
     * 					"oss:ListObjects"
     * 			  		],
     * 			  		"Effect": "Deny",
     * 			  		"Resource": [
     * 						"acs:oss:*:*:mybucket",
     * 						"acs:oss:*:*:mybucket/*"
     * 			  		]
     * 				 }
     * 		  		],
     * 				"Version": "1"
     * 			}
     * `),
     * 			Description: pulumi.String("this is a policy example"),
     * 			Force:       pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ram.NewUserPolicyAttachment(ctx, "default", &ram.UserPolicyAttachmentArgs{
     * 			PolicyName: defaultPolicy.PolicyName,
     * 			UserName:   defaultUser.Name,
     * 			PolicyType: defaultPolicy.Type,
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		usersDs := ram.GetUsersOutput(ctx, ram.GetUsersOutputArgs{
     * 			OutputFile: pulumi.String("users.txt"),
     * 			GroupName:  _default.Name,
     * 			PolicyName: defaultPolicy.PolicyName,
     * 			PolicyType: pulumi.String("Custom"),
     * 			NameRegex:  defaultUser.Name,
     * 		}, nil)
     * 		ctx.Export("firstUserId", usersDs.ApplyT(func(usersDs ram.GetUsersResult) (*string, error) {
     * 			return &usersDs.Users[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.Group;
     * import com.pulumi.alicloud.ram.GroupArgs;
     * import com.pulumi.alicloud.ram.User;
     * import com.pulumi.alicloud.ram.UserArgs;
     * import com.pulumi.alicloud.ram.GroupMembership;
     * import com.pulumi.alicloud.ram.GroupMembershipArgs;
     * import com.pulumi.alicloud.ram.Policy;
     * import com.pulumi.alicloud.ram.PolicyArgs;
     * import com.pulumi.alicloud.ram.UserPolicyAttachment;
     * import com.pulumi.alicloud.ram.UserPolicyAttachmentArgs;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new Group("default", GroupArgs.builder()
     *             .name("group1")
     *             .comments("group comments")
     *             .force(true)
     *             .build());
     *         var defaultUser = new User("defaultUser", UserArgs.builder()
     *             .name("user-example")
     *             .displayName("displayname")
     *             .mobile("86-18888888888")
     *             .email("hello.uuu@aaa.com")
     *             .comments("yoyoyo")
     *             .build());
     *         var defaultGroupMembership = new GroupMembership("defaultGroupMembership", GroupMembershipArgs.builder()
     *             .groupName(default_.name())
     *             .userNames(defaultUser.name())
     *             .build());
     *         var defaultPolicy = new Policy("defaultPolicy", PolicyArgs.builder()
     *             .policyName("ram-policy-example")
     *             .policyDocument("""
     * 			{
     * 				"Statement": [
     * 				 {
     * 					"Action": [
     * 					"oss:ListObjects",
     * 					"oss:ListObjects"
     * 			  		],
     * 			  		"Effect": "Deny",
     * 			  		"Resource": [
     * 						"acs:oss:*:*:mybucket",
     * 						"acs:oss:*:*:mybucket/*"
     * 			  		]
     * 				 }
     * 		  		],
     * 				"Version": "1"
     * 			}
     *             """)
     *             .description("this is a policy example")
     *             .force(true)
     *             .build());
     *         var defaultUserPolicyAttachment = new UserPolicyAttachment("defaultUserPolicyAttachment", UserPolicyAttachmentArgs.builder()
     *             .policyName(defaultPolicy.policyName())
     *             .userName(defaultUser.name())
     *             .policyType(defaultPolicy.type())
     *             .build());
     *         final var usersDs = RamFunctions.getUsers(GetUsersArgs.builder()
     *             .outputFile("users.txt")
     *             .groupName(default_.name())
     *             .policyName(defaultPolicy.policyName())
     *             .policyType("Custom")
     *             .nameRegex(defaultUser.name())
     *             .build());
     *         ctx.export("firstUserId", usersDs.applyValue(getUsersResult -> getUsersResult).applyValue(usersDs -> usersDs.applyValue(getUsersResult -> getUsersResult.users()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:ram:Group
     *     properties:
     *       name: group1
     *       comments: group comments
     *       force: true
     *   defaultUser:
     *     type: alicloud:ram:User
     *     name: default
     *     properties:
     *       name: user-example
     *       displayName: displayname
     *       mobile: 86-18888888888
     *       email: hello.uuu@aaa.com
     *       comments: yoyoyo
     *   defaultGroupMembership:
     *     type: alicloud:ram:GroupMembership
     *     name: default
     *     properties:
     *       groupName: ${default.name}
     *       userNames:
     *         - ${defaultUser.name}
     *   defaultPolicy:
     *     type: alicloud:ram:Policy
     *     name: default
     *     properties:
     *       policyName: ram-policy-example
     *       policyDocument: |
     *         			{
     *         				"Statement": [
     *         				 {
     *         					"Action": [
     *         					"oss:ListObjects",
     *         					"oss:ListObjects"
     *         			  		],
     *         			  		"Effect": "Deny",
     *         			  		"Resource": [
     *         						"acs:oss:*:*:mybucket",
     *         						"acs:oss:*:*:mybucket/*"
     *         			  		]
     *         				 }
     *         		  		],
     *         				"Version": "1"
     *         			}
     *       description: this is a policy example
     *       force: true
     *   defaultUserPolicyAttachment:
     *     type: alicloud:ram:UserPolicyAttachment
     *     name: default
     *     properties:
     *       policyName: ${defaultPolicy.policyName}
     *       userName: ${defaultUser.name}
     *       policyType: ${defaultPolicy.type}
     * variables:
     *   usersDs:
     *     fn::invoke:
     *       Function: alicloud:ram:getUsers
     *       Arguments:
     *         outputFile: users.txt
     *         groupName: ${default.name}
     *         policyName: ${defaultPolicy.policyName}
     *         policyType: Custom
     *         nameRegex: ${defaultUser.name}
     * outputs:
     *   firstUserId: ${usersDs.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     * */*/*/*/*/*/
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param groupName Filter results by a specific group name. Returned users are in the specified group.
     * @param ids A list of ram user IDs.
     * @param nameRegex A regex string to filter resulting users by their names.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param policyName Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. Returned users are attached to the specified policy.
     * @param policyType Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(
        groupName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        policyName: String? = null,
        policyType: String? = null,
    ): GetUsersResult {
        val argument = GetUsersPlainArgs(
            groupName = groupName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            policyName = policyName,
            policyType = policyType,
        )
        return getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ram&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit): GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUsersResultToKotlin(getUsersPlain(builtArgument.toJava()).await())
    }
}
