@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Role].
 */
@PulumiTagMarker
public class RoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleArgs = RoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleArgsBuilder.() -> Unit) {
        val builder = RoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Role {
        val builtJavaResource = com.pulumi.alicloud.ram.Role(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Role(builtJavaResource)
    }
}

/**
 * Provides a RAM Role resource.
 * > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.
 * > **NOTE:** Available since v1.0.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new RAM Role.
 * const role = new alicloud.ram.Role("role", {
 *     name: "terraform-example",
 *     document: `  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `,
 *     description: "this is a role test.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new RAM Role.
 * role = alicloud.ram.Role("role",
 *     name="terraform-example",
 *     document="""  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * """,
 *     description="this is a role test.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new RAM Role.
 *     var role = new AliCloud.Ram.Role("role", new()
 *     {
 *         Name = "terraform-example",
 *         Document = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": ""sts:AssumeRole"",
 *         ""Effect"": ""Allow"",
 *         ""Principal"": {
 *           ""Service"": [
 *             ""apigateway.aliyuncs.com"",
 *             ""ecs.aliyuncs.com""
 *           ]
 *         }
 *       }
 *     ],
 *     ""Version"": ""1""
 *   }
 * ",
 *         Description = "this is a role test.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new RAM Role.
 * 		_, err := ram.NewRole(ctx, "role", &ram.RoleArgs{
 * 			Name: pulumi.String("terraform-example"),
 * 			Document: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `),
 * 			Description: pulumi.String("this is a role test."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new RAM Role.
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("terraform-example")
 *             .document("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 *             """)
 *             .description("this is a role test.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new RAM Role.
 *   role:
 *     type: alicloud:ram:Role
 *     properties:
 *       name: terraform-example
 *       document: "  {\n    \"Statement\": [\n      {\n        \"Action\": \"sts:AssumeRole\",\n        \"Effect\": \"Allow\",\n        \"Principal\": {\n          \"Service\": [\n            \"apigateway&#46;aliyuncs&#46;com\", \n            \"ecs&#46;aliyuncs&#46;com\"\n          ]\n        }\n      }\n    ],\n    \"Version\": \"1\"\n  }\n"
 *       description: this is a role test.
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM role can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/role:Role example my-role
 * ```
 */
public class Role internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.Role,
) : KotlinCustomResource(javaResource, RoleMapper) {
    /**
     * The role arn.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the RAM role. This name can have a string of 1 to 1024 characters. **NOTE:** The `description` supports modification since V1.144.0.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Authorization strategy of the RAM role. It is required when the `services` and `ram_users` are not specified.
     */
    public val document: Output<String>
        get() = javaResource.document().applyValue({ args0 -> args0 })

    /**
     * This parameter is used for resource destroy. Default value is `false`.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum session duration of the RAM role. Valid values: 3600 to 43200. Unit: seconds. Default value: 3600. The default value is used if the parameter is not specified.
     */
    public val maxSessionDuration: Output<Int>?
        get() = javaResource.maxSessionDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the RAM role. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of ram users who can assume the RAM role. The format of each item in this list is `acs:ram::${account_id}:root` or `acs:ram::${account_id}:user/${user_name}`, such as `acs:ram::1234567890000:root` and `acs:ram::1234567890001:user/Mary`. The `${user_name}` is the name of a RAM user which must exists in the Alicloud account indicated by the `${account_id}`.
     */
    @Deprecated(
        message = """
  Field 'ram_users' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val ramUsers: Output<List<String>>
        get() = javaResource.ramUsers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The role ID.
     */
    public val roleId: Output<String>
        get() = javaResource.roleId().applyValue({ args0 -> args0 })

    /**
     * (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of services which can assume the RAM role. The format of each item in this list is `${service}.aliyuncs.com` or `${account_id}@${service}.aliyuncs.com`, such as `ecs.aliyuncs.com` and `1234567890000@ots.aliyuncs.com`. The `${service}` can be `ecs`, `log`, `apigateway` and so on, the `${account_id}` refers to someone's Alicloud account id.
     */
    @Deprecated(
        message = """
  Field 'services' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val services: Output<List<String>>
        get() = javaResource.services().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM role policy document. Valid value is `1`. Default value is `1`.
     */
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object RoleMapper : ResourceMapper<Role> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.Role::class == javaResource::class

    override fun map(javaResource: Resource): Role = Role(
        javaResource as
            com.pulumi.alicloud.ram.Role,
    )
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Role].
 */
public suspend fun role(name: String, block: suspend RoleResourceBuilder.() -> Unit): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 */
public fun role(name: String): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
