@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.RoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a RAM Role resource.
 * > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.
 * > **NOTE:** Available since v1.0.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new RAM Role.
 * const role = new alicloud.ram.Role("role", {
 *     name: "terraform-example",
 *     document: `  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `,
 *     description: "this is a role test.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new RAM Role.
 * role = alicloud.ram.Role("role",
 *     name="terraform-example",
 *     document="""  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * """,
 *     description="this is a role test.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new RAM Role.
 *     var role = new AliCloud.Ram.Role("role", new()
 *     {
 *         Name = "terraform-example",
 *         Document = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": ""sts:AssumeRole"",
 *         ""Effect"": ""Allow"",
 *         ""Principal"": {
 *           ""Service"": [
 *             ""apigateway.aliyuncs.com"",
 *             ""ecs.aliyuncs.com""
 *           ]
 *         }
 *       }
 *     ],
 *     ""Version"": ""1""
 *   }
 * ",
 *         Description = "this is a role test.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new RAM Role.
 * 		_, err := ram.NewRole(ctx, "role", &ram.RoleArgs{
 * 			Name: pulumi.String("terraform-example"),
 * 			Document: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 * `),
 * 			Description: pulumi.String("this is a role test."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new RAM Role.
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("terraform-example")
 *             .document("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": "sts:AssumeRole",
 *         "Effect": "Allow",
 *         "Principal": {
 *           "Service": [
 *             "apigateway.aliyuncs.com",
 *             "ecs.aliyuncs.com"
 *           ]
 *         }
 *       }
 *     ],
 *     "Version": "1"
 *   }
 *             """)
 *             .description("this is a role test.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new RAM Role.
 *   role:
 *     type: alicloud:ram:Role
 *     properties:
 *       name: terraform-example
 *       document: "  {\n    \"Statement\": [\n      {\n        \"Action\": \"sts:AssumeRole\",\n        \"Effect\": \"Allow\",\n        \"Principal\": {\n          \"Service\": [\n            \"apigateway&#46;aliyuncs&#46;com\", \n            \"ecs&#46;aliyuncs&#46;com\"\n          ]\n        }\n      }\n    ],\n    \"Version\": \"1\"\n  }\n"
 *       description: this is a role test.
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM role can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/role:Role example my-role
 * ```
 * @property description Description of the RAM role. This name can have a string of 1 to 1024 characters. **NOTE:** The `description` supports modification since V1.144.0.
 * @property document Authorization strategy of the RAM role. It is required when the `services` and `ram_users` are not specified.
 * @property force This parameter is used for resource destroy. Default value is `false`.
 * @property maxSessionDuration The maximum session duration of the RAM role. Valid values: 3600 to 43200. Unit: seconds. Default value: 3600. The default value is used if the parameter is not specified.
 * @property name Name of the RAM role. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
 * @property ramUsers (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of ram users who can assume the RAM role. The format of each item in this list is `acs:ram::${account_id}:root` or `acs:ram::${account_id}:user/${user_name}`, such as `acs:ram::1234567890000:root` and `acs:ram::1234567890001:user/Mary`. The `${user_name}` is the name of a RAM user which must exists in the Alicloud account indicated by the `${account_id}`.
 * @property services (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of services which can assume the RAM role. The format of each item in this list is `${service}.aliyuncs.com` or `${account_id}@${service}.aliyuncs.com`, such as `ecs.aliyuncs.com` and `1234567890000@ots.aliyuncs.com`. The `${service}` can be `ecs`, `log`, `apigateway` and so on, the `${account_id}` refers to someone's Alicloud account id.
 * @property version (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM role policy document. Valid value is `1`. Default value is `1`.
 */
public data class RoleArgs(
    public val description: Output<String>? = null,
    public val document: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    public val maxSessionDuration: Output<Int>? = null,
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'ram_users' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val ramUsers: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'services' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val services: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.RoleArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.RoleArgs =
        com.pulumi.alicloud.ram.RoleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .document(document?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .maxSessionDuration(maxSessionDuration?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ramUsers(ramUsers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .services(services?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleArgs].
 */
@PulumiTagMarker
public class RoleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var document: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var maxSessionDuration: Output<Int>? = null

    private var name: Output<String>? = null

    private var ramUsers: Output<List<String>>? = null

    private var services: Output<List<String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Description of the RAM role. This name can have a string of 1 to 1024 characters. **NOTE:** The `description` supports modification since V1.144.0.
     */
    @JvmName("ynkyunbxnmjinbgk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Authorization strategy of the RAM role. It is required when the `services` and `ram_users` are not specified.
     */
    @JvmName("lhdfoquduurkprpo")
    public suspend fun document(`value`: Output<String>) {
        this.document = value
    }

    /**
     * @param value This parameter is used for resource destroy. Default value is `false`.
     */
    @JvmName("brixgohnnriargey")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value The maximum session duration of the RAM role. Valid values: 3600 to 43200. Unit: seconds. Default value: 3600. The default value is used if the parameter is not specified.
     */
    @JvmName("sqqlpsbidsgyprgh")
    public suspend fun maxSessionDuration(`value`: Output<Int>) {
        this.maxSessionDuration = value
    }

    /**
     * @param value Name of the RAM role. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
     */
    @JvmName("ysquoxirxfnfukvo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of ram users who can assume the RAM role. The format of each item in this list is `acs:ram::${account_id}:root` or `acs:ram::${account_id}:user/${user_name}`, such as `acs:ram::1234567890000:root` and `acs:ram::1234567890001:user/Mary`. The `${user_name}` is the name of a RAM user which must exists in the Alicloud account indicated by the `${account_id}`.
     */
    @Deprecated(
        message = """
  Field 'ram_users' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("vemdrgjcjhbjvmer")
    public suspend fun ramUsers(`value`: Output<List<String>>) {
        this.ramUsers = value
    }

    @JvmName("orxgfhdatfxxygrx")
    public suspend fun ramUsers(vararg values: Output<String>) {
        this.ramUsers = Output.all(values.asList())
    }

    /**
     * @param values (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of ram users who can assume the RAM role. The format of each item in this list is `acs:ram::${account_id}:root` or `acs:ram::${account_id}:user/${user_name}`, such as `acs:ram::1234567890000:root` and `acs:ram::1234567890001:user/Mary`. The `${user_name}` is the name of a RAM user which must exists in the Alicloud account indicated by the `${account_id}`.
     */
    @Deprecated(
        message = """
  Field 'ram_users' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("mwghmencjjiawqtg")
    public suspend fun ramUsers(values: List<Output<String>>) {
        this.ramUsers = Output.all(values)
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of services which can assume the RAM role. The format of each item in this list is `${service}.aliyuncs.com` or `${account_id}@${service}.aliyuncs.com`, such as `ecs.aliyuncs.com` and `1234567890000@ots.aliyuncs.com`. The `${service}` can be `ecs`, `log`, `apigateway` and so on, the `${account_id}` refers to someone's Alicloud account id.
     */
    @Deprecated(
        message = """
  Field 'services' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("vdcxaecrkbtvxxhb")
    public suspend fun services(`value`: Output<List<String>>) {
        this.services = value
    }

    @JvmName("nlbqqkmmcwitdusx")
    public suspend fun services(vararg values: Output<String>) {
        this.services = Output.all(values.asList())
    }

    /**
     * @param values (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of services which can assume the RAM role. The format of each item in this list is `${service}.aliyuncs.com` or `${account_id}@${service}.aliyuncs.com`, such as `ecs.aliyuncs.com` and `1234567890000@ots.aliyuncs.com`. The `${service}` can be `ecs`, `log`, `apigateway` and so on, the `${account_id}` refers to someone's Alicloud account id.
     */
    @Deprecated(
        message = """
  Field 'services' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("fvhkmohigbfeiwxt")
    public suspend fun services(values: List<Output<String>>) {
        this.services = Output.all(values)
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM role policy document. Valid value is `1`. Default value is `1`.
     */
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("bufxywqufjvogiag")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Description of the RAM role. This name can have a string of 1 to 1024 characters. **NOTE:** The `description` supports modification since V1.144.0.
     */
    @JvmName("kfewevkdkmuxibhc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Authorization strategy of the RAM role. It is required when the `services` and `ram_users` are not specified.
     */
    @JvmName("fbmbwvqwbblnfcuk")
    public suspend fun document(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.document = mapped
    }

    /**
     * @param value This parameter is used for resource destroy. Default value is `false`.
     */
    @JvmName("purutvumpclkihyx")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value The maximum session duration of the RAM role. Valid values: 3600 to 43200. Unit: seconds. Default value: 3600. The default value is used if the parameter is not specified.
     */
    @JvmName("kdawwhykeyfnmrng")
    public suspend fun maxSessionDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSessionDuration = mapped
    }

    /**
     * @param value Name of the RAM role. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
     */
    @JvmName("evxlswpejlxxbyqd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of ram users who can assume the RAM role. The format of each item in this list is `acs:ram::${account_id}:root` or `acs:ram::${account_id}:user/${user_name}`, such as `acs:ram::1234567890000:root` and `acs:ram::1234567890001:user/Mary`. The `${user_name}` is the name of a RAM user which must exists in the Alicloud account indicated by the `${account_id}`.
     */
    @Deprecated(
        message = """
  Field 'ram_users' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("qgyvbvdfvdpvfstm")
    public suspend fun ramUsers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramUsers = mapped
    }

    /**
     * @param values (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of ram users who can assume the RAM role. The format of each item in this list is `acs:ram::${account_id}:root` or `acs:ram::${account_id}:user/${user_name}`, such as `acs:ram::1234567890000:root` and `acs:ram::1234567890001:user/Mary`. The `${user_name}` is the name of a RAM user which must exists in the Alicloud account indicated by the `${account_id}`.
     */
    @Deprecated(
        message = """
  Field 'ram_users' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("yikiqqpaoomtujyd")
    public suspend fun ramUsers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ramUsers = mapped
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of services which can assume the RAM role. The format of each item in this list is `${service}.aliyuncs.com` or `${account_id}@${service}.aliyuncs.com`, such as `ecs.aliyuncs.com` and `1234567890000@ots.aliyuncs.com`. The `${service}` can be `ecs`, `log`, `apigateway` and so on, the `${account_id}` refers to someone's Alicloud account id.
     */
    @Deprecated(
        message = """
  Field 'services' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("klkbvtemamniyrgp")
    public suspend fun services(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param values (It has been deprecated since version 1.49.0, and use field 'document' to replace.) List of services which can assume the RAM role. The format of each item in this list is `${service}.aliyuncs.com` or `${account_id}@${service}.aliyuncs.com`, such as `ecs.aliyuncs.com` and `1234567890000@ots.aliyuncs.com`. The `${service}` can be `ecs`, `log`, `apigateway` and so on, the `${account_id}` refers to someone's Alicloud account id.
     */
    @Deprecated(
        message = """
  Field 'services' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("qipcgnhxhaybqger")
    public suspend fun services(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param value (It has been deprecated since version 1.49.0, and use field 'document' to replace.) Version of the RAM role policy document. Valid value is `1`. Default value is `1`.
     */
    @Deprecated(
        message = """
  Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. 
  """,
    )
    @JvmName("hwxnspkspabkqchk")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RoleArgs = RoleArgs(
        description = description,
        document = document,
        force = force,
        maxSessionDuration = maxSessionDuration,
        name = name,
        ramUsers = ramUsers,
        services = services,
        version = version,
    )
}
