@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RolePolicyAttachment].
 */
@PulumiTagMarker
public class RolePolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RolePolicyAttachmentArgs = RolePolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RolePolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = RolePolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RolePolicyAttachment {
        val builtJavaResource = com.pulumi.alicloud.ram.RolePolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RolePolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides a RAM Role attachment resource.
 * > **NOTE:** Available since v1.0.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * // Create a RAM Role Policy attachment.
 * const role = new alicloud.ram.Role("role", {
 *     name: "roleName",
 *     document: `    {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "apigateway.aliyuncs.com",
 *               "ecs.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *     }
 * `,
 *     description: "this is a role test.",
 * });
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const policy = new alicloud.ram.Policy("policy", {
 *     policyName: `tf-example-${_default.result}`,
 *     policyDocument: `  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `,
 *     description: "this is a policy test",
 * });
 * const attach = new alicloud.ram.RolePolicyAttachment("attach", {
 *     policyName: policy.policyName,
 *     policyType: policy.type,
 *     roleName: role.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * # Create a RAM Role Policy attachment.
 * role = alicloud.ram.Role("role",
 *     name="roleName",
 *     document="""    {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "apigateway.aliyuncs.com",
 *               "ecs.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *     }
 * """,
 *     description="this is a role test.")
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * policy = alicloud.ram.Policy("policy",
 *     policy_name=f"tf-example-{default['result']}",
 *     policy_document="""  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * """,
 *     description="this is a policy test")
 * attach = alicloud.ram.RolePolicyAttachment("attach",
 *     policy_name=policy.policy_name,
 *     policy_type=policy.type,
 *     role_name=role.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a RAM Role Policy attachment.
 *     var role = new AliCloud.Ram.Role("role", new()
 *     {
 *         Name = "roleName",
 *         Document = @"    {
 *       ""Statement"": [
 *         {
 *           ""Action"": ""sts:AssumeRole"",
 *           ""Effect"": ""Allow"",
 *           ""Principal"": {
 *             ""Service"": [
 *               ""apigateway.aliyuncs.com"",
 *               ""ecs.aliyuncs.com""
 *             ]
 *           }
 *         }
 *       ],
 *       ""Version"": ""1""
 *     }
 * ",
 *         Description = "this is a role test.",
 *     });
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var policy = new AliCloud.Ram.Policy("policy", new()
 *     {
 *         PolicyName = $"tf-example-{@default.Result}",
 *         PolicyDocument = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": [
 *           ""oss:ListObjects"",
 *           ""oss:GetObject""
 *         ],
 *         ""Effect"": ""Allow"",
 *         ""Resource"": [
 *           ""acs:oss:*:*:mybucket"",
 *           ""acs:oss:*:*:mybucket/*""
 *         ]
 *       }
 *     ],
 *       ""Version"": ""1""
 *   }
 * ",
 *         Description = "this is a policy test",
 *     });
 *     var attach = new AliCloud.Ram.RolePolicyAttachment("attach", new()
 *     {
 *         PolicyName = policy.PolicyName,
 *         PolicyType = policy.Type,
 *         RoleName = role.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a RAM Role Policy attachment.
 * 		role, err := ram.NewRole(ctx, "role", &ram.RoleArgs{
 * 			Name: pulumi.String("roleName"),
 * 			Document: pulumi.String(`    {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "apigateway.aliyuncs.com",
 *               "ecs.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *     }
 * `),
 * 			Description: pulumi.String("this is a role test."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy, err := ram.NewPolicy(ctx, "policy", &ram.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			PolicyDocument: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `),
 * 			Description: pulumi.String("this is a policy test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewRolePolicyAttachment(ctx, "attach", &ram.RolePolicyAttachmentArgs{
 * 			PolicyName: policy.PolicyName,
 * 			PolicyType: policy.Type,
 * 			RoleName:   role.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ram.Policy;
 * import com.pulumi.alicloud.ram.PolicyArgs;
 * import com.pulumi.alicloud.ram.RolePolicyAttachment;
 * import com.pulumi.alicloud.ram.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a RAM Role Policy attachment.
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("roleName")
 *             .document("""
 *     {
 *       "Statement": [
 *         {
 *           "Action": "sts:AssumeRole",
 *           "Effect": "Allow",
 *           "Principal": {
 *             "Service": [
 *               "apigateway.aliyuncs.com",
 *               "ecs.aliyuncs.com"
 *             ]
 *           }
 *         }
 *       ],
 *       "Version": "1"
 *     }
 *             """)
 *             .description("this is a role test.")
 *             .build());
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName(String.format("tf-example-%s", default_.result()))
 *             .policyDocument("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 *             """)
 *             .description("this is a policy test")
 *             .build());
 *         var attach = new RolePolicyAttachment("attach", RolePolicyAttachmentArgs.builder()
 *             .policyName(policy.policyName())
 *             .policyType(policy.type())
 *             .roleName(role.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a RAM Role Policy attachment.
 *   role:
 *     type: alicloud:ram:Role
 *     properties:
 *       name: roleName
 *       document: "    {\n      \"Statement\": [\n        {\n          \"Action\": \"sts:AssumeRole\",\n          \"Effect\": \"Allow\",\n          \"Principal\": {\n            \"Service\": [\n              \"apigateway&#46;aliyuncs&#46;com\", \n              \"ecs&#46;aliyuncs&#46;com\"\n            ]\n          }\n        }\n      ],\n      \"Version\": \"1\"\n    }\n"
 *       description: this is a role test.
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   policy:
 *     type: alicloud:ram:Policy
 *     properties:
 *       policyName: tf-example-${default.result}
 *       policyDocument: |2
 *           {
 *             "Statement": [
 *               {
 *                 "Action": [
 *                   "oss:ListObjects",
 *                   "oss:GetObject"
 *                 ],
 *                 "Effect": "Allow",
 *                 "Resource": [
 *                   "acs:oss:*:*:mybucket",
 *                   "acs:oss:*:*:mybucket/*"
 *                 ]
 *               }
 *             ],
 *               "Version": "1"
 *           }
 *       description: this is a policy test
 *   attach:
 *     type: alicloud:ram:RolePolicyAttachment
 *     properties:
 *       policyName: ${policy.policyName}
 *       policyType: ${policy.type}
 *       roleName: ${role.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM Role Policy attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/rolePolicyAttachment:RolePolicyAttachment example role:my-policy:Custom:my-role
 * ```
 * */*/*/*/*/*/
 */
public class RolePolicyAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.RolePolicyAttachment,
) : KotlinCustomResource(javaResource, RolePolicyAttachmentMapper) {
    /**
     * Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * Type of the RAM policy. It must be `Custom` or `System`.
     */
    public val policyType: Output<String>
        get() = javaResource.policyType().applyValue({ args0 -> args0 })

    /**
     * Name of the RAM Role. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
     */
    public val roleName: Output<String>
        get() = javaResource.roleName().applyValue({ args0 -> args0 })
}

public object RolePolicyAttachmentMapper : ResourceMapper<RolePolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.RolePolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): RolePolicyAttachment = RolePolicyAttachment(
        javaResource
            as com.pulumi.alicloud.ram.RolePolicyAttachment,
    )
}

/**
 * @see [RolePolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RolePolicyAttachment].
 */
public suspend fun rolePolicyAttachment(
    name: String,
    block: suspend RolePolicyAttachmentResourceBuilder.() -> Unit,
): RolePolicyAttachment {
    val builder = RolePolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RolePolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rolePolicyAttachment(name: String): RolePolicyAttachment {
    val builder = RolePolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
