@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityPreference].
 */
@PulumiTagMarker
public class SecurityPreferenceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityPreferenceArgs = SecurityPreferenceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityPreferenceArgsBuilder.() -> Unit) {
        val builder = SecurityPreferenceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityPreference {
        val builtJavaResource = com.pulumi.alicloud.ram.SecurityPreference(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityPreference(builtJavaResource)
    }
}

/**
 * Provides a RAM Security Preference resource.
 * For information about RAM Security Preference and how to use it, see [What is Security Preference](https://www.alibabacloud.com/help/en/doc-detail/186694.htm).
 * > **NOTE:** Available since v1.152.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ram.SecurityPreference("example", {
 *     enableSaveMfaTicket: false,
 *     allowUserToChangePassword: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ram.SecurityPreference("example",
 *     enable_save_mfa_ticket=False,
 *     allow_user_to_change_password=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ram.SecurityPreference("example", new()
 *     {
 *         EnableSaveMfaTicket = false,
 *         AllowUserToChangePassword = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewSecurityPreference(ctx, "example", &ram.SecurityPreferenceArgs{
 * 			EnableSaveMfaTicket:       pulumi.Bool(false),
 * 			AllowUserToChangePassword: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.SecurityPreference;
 * import com.pulumi.alicloud.ram.SecurityPreferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityPreference("example", SecurityPreferenceArgs.builder()
 *             .enableSaveMfaTicket(false)
 *             .allowUserToChangePassword(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ram:SecurityPreference
 *     properties:
 *       enableSaveMfaTicket: false
 *       allowUserToChangePassword: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM Security Preference can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/securityPreference:SecurityPreference example <id>
 * ```
 */
public class SecurityPreference internal constructor(
    override val javaResource: com.pulumi.alicloud.ram.SecurityPreference,
) : KotlinCustomResource(javaResource, SecurityPreferenceMapper) {
    /**
     * Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
     */
    public val allowUserToChangePassword: Output<Boolean>
        get() = javaResource.allowUserToChangePassword().applyValue({ args0 -> args0 })

    /**
     * Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
     */
    public val allowUserToManageAccessKeys: Output<Boolean>
        get() = javaResource.allowUserToManageAccessKeys().applyValue({ args0 -> args0 })

    /**
     * Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
     */
    public val allowUserToManageMfaDevices: Output<Boolean>
        get() = javaResource.allowUserToManageMfaDevices().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
     */
    public val enableSaveMfaTicket: Output<Boolean>
        get() = javaResource.enableSaveMfaTicket().applyValue({ args0 -> args0 })

    /**
     * Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
     */
    public val enforceMfaForLogin: Output<Boolean>
        get() = javaResource.enforceMfaForLogin().applyValue({ args0 -> args0 })

    /**
     * The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
     * * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
     * * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
     * * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
     */
    public val loginNetworkMasks: Output<String>?
        get() = javaResource.loginNetworkMasks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
     */
    public val loginSessionDuration: Output<Int>
        get() = javaResource.loginSessionDuration().applyValue({ args0 -> args0 })
}

public object SecurityPreferenceMapper : ResourceMapper<SecurityPreference> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ram.SecurityPreference::class == javaResource::class

    override fun map(javaResource: Resource): SecurityPreference = SecurityPreference(
        javaResource as
            com.pulumi.alicloud.ram.SecurityPreference,
    )
}

/**
 * @see [SecurityPreference].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityPreference].
 */
public suspend fun securityPreference(
    name: String,
    block: suspend SecurityPreferenceResourceBuilder.() -> Unit,
): SecurityPreference {
    val builder = SecurityPreferenceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityPreference].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityPreference(name: String): SecurityPreference {
    val builder = SecurityPreferenceResourceBuilder()
    builder.name(name)
    return builder.build()
}
