@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.SecurityPreferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RAM Security Preference resource.
 * For information about RAM Security Preference and how to use it, see [What is Security Preference](https://www.alibabacloud.com/help/en/doc-detail/186694.htm).
 * > **NOTE:** Available since v1.152.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ram.SecurityPreference("example", {
 *     enableSaveMfaTicket: false,
 *     allowUserToChangePassword: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ram.SecurityPreference("example",
 *     enable_save_mfa_ticket=False,
 *     allow_user_to_change_password=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ram.SecurityPreference("example", new()
 *     {
 *         EnableSaveMfaTicket = false,
 *         AllowUserToChangePassword = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewSecurityPreference(ctx, "example", &ram.SecurityPreferenceArgs{
 * 			EnableSaveMfaTicket:       pulumi.Bool(false),
 * 			AllowUserToChangePassword: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.SecurityPreference;
 * import com.pulumi.alicloud.ram.SecurityPreferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityPreference("example", SecurityPreferenceArgs.builder()
 *             .enableSaveMfaTicket(false)
 *             .allowUserToChangePassword(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ram:SecurityPreference
 *     properties:
 *       enableSaveMfaTicket: false
 *       allowUserToChangePassword: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM Security Preference can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/securityPreference:SecurityPreference example <id>
 * ```
 * @property allowUserToChangePassword Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
 * @property allowUserToManageAccessKeys Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
 * @property allowUserToManageMfaDevices Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
 * @property enableSaveMfaTicket Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
 * @property enforceMfaForLogin Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
 * @property loginNetworkMasks The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
 * * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
 * * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
 * * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
 * @property loginSessionDuration The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
 */
public data class SecurityPreferenceArgs(
    public val allowUserToChangePassword: Output<Boolean>? = null,
    public val allowUserToManageAccessKeys: Output<Boolean>? = null,
    public val allowUserToManageMfaDevices: Output<Boolean>? = null,
    public val enableSaveMfaTicket: Output<Boolean>? = null,
    public val enforceMfaForLogin: Output<Boolean>? = null,
    public val loginNetworkMasks: Output<String>? = null,
    public val loginSessionDuration: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.SecurityPreferenceArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.SecurityPreferenceArgs =
        com.pulumi.alicloud.ram.SecurityPreferenceArgs.builder()
            .allowUserToChangePassword(allowUserToChangePassword?.applyValue({ args0 -> args0 }))
            .allowUserToManageAccessKeys(allowUserToManageAccessKeys?.applyValue({ args0 -> args0 }))
            .allowUserToManageMfaDevices(allowUserToManageMfaDevices?.applyValue({ args0 -> args0 }))
            .enableSaveMfaTicket(enableSaveMfaTicket?.applyValue({ args0 -> args0 }))
            .enforceMfaForLogin(enforceMfaForLogin?.applyValue({ args0 -> args0 }))
            .loginNetworkMasks(loginNetworkMasks?.applyValue({ args0 -> args0 }))
            .loginSessionDuration(loginSessionDuration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityPreferenceArgs].
 */
@PulumiTagMarker
public class SecurityPreferenceArgsBuilder internal constructor() {
    private var allowUserToChangePassword: Output<Boolean>? = null

    private var allowUserToManageAccessKeys: Output<Boolean>? = null

    private var allowUserToManageMfaDevices: Output<Boolean>? = null

    private var enableSaveMfaTicket: Output<Boolean>? = null

    private var enforceMfaForLogin: Output<Boolean>? = null

    private var loginNetworkMasks: Output<String>? = null

    private var loginSessionDuration: Output<Int>? = null

    /**
     * @param value Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
     */
    @JvmName("hmfwkdkrcnmqknmc")
    public suspend fun allowUserToChangePassword(`value`: Output<Boolean>) {
        this.allowUserToChangePassword = value
    }

    /**
     * @param value Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
     */
    @JvmName("dvyihsujjkjdypxq")
    public suspend fun allowUserToManageAccessKeys(`value`: Output<Boolean>) {
        this.allowUserToManageAccessKeys = value
    }

    /**
     * @param value Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
     */
    @JvmName("mdjjlegelqtvmgqy")
    public suspend fun allowUserToManageMfaDevices(`value`: Output<Boolean>) {
        this.allowUserToManageMfaDevices = value
    }

    /**
     * @param value Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
     */
    @JvmName("rymbltfjsrayxlli")
    public suspend fun enableSaveMfaTicket(`value`: Output<Boolean>) {
        this.enableSaveMfaTicket = value
    }

    /**
     * @param value Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
     */
    @JvmName("wrjmydsqdosuxijv")
    public suspend fun enforceMfaForLogin(`value`: Output<Boolean>) {
        this.enforceMfaForLogin = value
    }

    /**
     * @param value The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
     * * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
     * * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
     * * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
     */
    @JvmName("ujsdrvtrwnfwxecq")
    public suspend fun loginNetworkMasks(`value`: Output<String>) {
        this.loginNetworkMasks = value
    }

    /**
     * @param value The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
     */
    @JvmName("lmnfxxtfpvdxglvk")
    public suspend fun loginSessionDuration(`value`: Output<Int>) {
        this.loginSessionDuration = value
    }

    /**
     * @param value Specifies whether RAM users can change their passwords. Valid values: `true` and `false`
     */
    @JvmName("mskqaewnvvwcciwt")
    public suspend fun allowUserToChangePassword(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUserToChangePassword = mapped
    }

    /**
     * @param value Specifies whether RAM users can manage their AccessKey pairs. Valid values: `true` and `false`
     */
    @JvmName("cnxogydpwcupjarc")
    public suspend fun allowUserToManageAccessKeys(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUserToManageAccessKeys = mapped
    }

    /**
     * @param value Specifies whether RAM users can manage their MFA devices. Valid values: `true` and `false`
     */
    @JvmName("xbapkkdvfumrgdac")
    public suspend fun allowUserToManageMfaDevices(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUserToManageMfaDevices = mapped
    }

    /**
     * @param value Specifies whether to remember the MFA devices for seven days. Valid values: `true` and `false`
     */
    @JvmName("cwioflowajntkwfg")
    public suspend fun enableSaveMfaTicket(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSaveMfaTicket = mapped
    }

    /**
     * @param value Specifies whether MFA is required for all RAM users when they log on to the Alibaba Cloud Management Console by using usernames and passwords. Valid values: `true` and `false`
     */
    @JvmName("qwdbiwfrcllhawem")
    public suspend fun enforceMfaForLogin(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceMfaForLogin = mapped
    }

    /**
     * @param value The subnet mask that specifies the IP addresses from which you can log on to the Alibaba Cloud Management Console. This parameter takes effect on password-based logon and single sign-on (SSO). However, this parameter does not take effect on API calls that are authenticated by using AccessKey pairs.**NOTE:** You can specify up to 25 subnet masks. The total length of the subnet masks can be a maximum of 512 characters.
     * * If you specify a subnet mask, RAM users can use only the IP addresses in the subnet mask to log on to the Alibaba Cloud Management Console.
     * * If you do not specify a subnet mask, RAM users can use all IP addresses to log on to the Alibaba Cloud Management Console.
     * * If you need to specify multiple subnet masks, separate the subnet masks with semicolons (;). Example: 192.168.0.0/16;10.0.0.0/8.
     */
    @JvmName("nxvuhqrcpxfwqrfa")
    public suspend fun loginNetworkMasks(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginNetworkMasks = mapped
    }

    /**
     * @param value The validity period of the logon session of RAM users. Valid values: 6 to 24. Unit: hours. Default value: 6.
     */
    @JvmName("emcxqdreqejgpkja")
    public suspend fun loginSessionDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginSessionDuration = mapped
    }

    internal fun build(): SecurityPreferenceArgs = SecurityPreferenceArgs(
        allowUserToChangePassword = allowUserToChangePassword,
        allowUserToManageAccessKeys = allowUserToManageAccessKeys,
        allowUserToManageMfaDevices = allowUserToManageMfaDevices,
        enableSaveMfaTicket = enableSaveMfaTicket,
        enforceMfaForLogin = enforceMfaForLogin,
        loginNetworkMasks = loginNetworkMasks,
        loginSessionDuration = loginSessionDuration,
    )
}
