@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RAM User resource.
 * For information about RAM User and how to use it, see [What is User](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createuser).
 * > **NOTE:** When you want to destroy this resource forcefully(means release all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new RAM user.
 * const user = new alicloud.ram.User("user", {
 *     name: "terraform-example",
 *     displayName: "user_display_name",
 *     mobile: "86-18688888888",
 *     email: "hello.uuu@aaa.com",
 *     comments: "yoyoyo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new RAM user.
 * user = alicloud.ram.User("user",
 *     name="terraform-example",
 *     display_name="user_display_name",
 *     mobile="86-18688888888",
 *     email="hello.uuu@aaa.com",
 *     comments="yoyoyo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new RAM user.
 *     var user = new AliCloud.Ram.User("user", new()
 *     {
 *         Name = "terraform-example",
 *         DisplayName = "user_display_name",
 *         Mobile = "86-18688888888",
 *         Email = "hello.uuu@aaa.com",
 *         Comments = "yoyoyo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new RAM user.
 * 		_, err := ram.NewUser(ctx, "user", &ram.UserArgs{
 * 			Name:        pulumi.String("terraform-example"),
 * 			DisplayName: pulumi.String("user_display_name"),
 * 			Mobile:      pulumi.String("86-18688888888"),
 * 			Email:       pulumi.String("hello.uuu@aaa.com"),
 * 			Comments:    pulumi.String("yoyoyo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new RAM user.
 *         var user = new User("user", UserArgs.builder()
 *             .name("terraform-example")
 *             .displayName("user_display_name")
 *             .mobile("86-18688888888")
 *             .email("hello.uuu@aaa.com")
 *             .comments("yoyoyo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new RAM user.
 *   user:
 *     type: alicloud:ram:User
 *     properties:
 *       name: terraform-example
 *       displayName: user_display_name
 *       mobile: 86-18688888888
 *       email: hello.uuu@aaa.com
 *       comments: yoyoyo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/user:User example 123456789xxx
 * ```
 * @property comments Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
 * @property displayName Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
 * @property email Email of the RAM user.
 * @property force This parameter is used for resource destroy. Default value: `false`.
 * @property mobile Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
 * @property name Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
 */
public data class UserArgs(
    public val comments: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val email: Output<String>? = null,
    public val force: Output<Boolean>? = null,
    public val mobile: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.UserArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.UserArgs =
        com.pulumi.alicloud.ram.UserArgs.builder()
            .comments(comments?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .mobile(mobile?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var comments: Output<String>? = null

    private var displayName: Output<String>? = null

    private var email: Output<String>? = null

    private var force: Output<Boolean>? = null

    private var mobile: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
     */
    @JvmName("ooygxsjwdwmnmuuu")
    public suspend fun comments(`value`: Output<String>) {
        this.comments = value
    }

    /**
     * @param value Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
     */
    @JvmName("ickscfvovsdekvok")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Email of the RAM user.
     */
    @JvmName("bnyweltndtiuryav")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value This parameter is used for resource destroy. Default value: `false`.
     */
    @JvmName("muwimgridtyugjxc")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
     */
    @JvmName("qswfamtjobnwsdbi")
    public suspend fun mobile(`value`: Output<String>) {
        this.mobile = value
    }

    /**
     * @param value Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("japadwolkmhnuqnl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
     */
    @JvmName("kahbonnhvkqypasl")
    public suspend fun comments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comments = mapped
    }

    /**
     * @param value Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
     */
    @JvmName("glelwexojdtkxatx")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Email of the RAM user.
     */
    @JvmName("orhkdqxqgcwygfab")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value This parameter is used for resource destroy. Default value: `false`.
     */
    @JvmName("jytdfecbhvptaclj")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
     */
    @JvmName("rkfwlekjtayorvlc")
    public suspend fun mobile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobile = mapped
    }

    /**
     * @param value Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("crivksqwmbbxamcq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        comments = comments,
        displayName = displayName,
        email = email,
        force = force,
        mobile = mobile,
        name = name,
    )
}
