@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin

import com.pulumi.alicloud.ram.UserPolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RAM User Policy attachment resource.
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * // Create a RAM User Policy attachment.
 * const user = new alicloud.ram.User("user", {
 *     name: "userName",
 *     displayName: "user_display_name",
 *     mobile: "86-18688888888",
 *     email: "hello.uuu@aaa.com",
 *     comments: "yoyoyo",
 * });
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const policy = new alicloud.ram.Policy("policy", {
 *     policyName: `tf-example-${_default.result}`,
 *     policyDocument: `  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `,
 *     description: "this is a policy test",
 * });
 * const attach = new alicloud.ram.UserPolicyAttachment("attach", {
 *     policyName: policy.policyName,
 *     policyType: policy.type,
 *     userName: user.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * # Create a RAM User Policy attachment.
 * user = alicloud.ram.User("user",
 *     name="userName",
 *     display_name="user_display_name",
 *     mobile="86-18688888888",
 *     email="hello.uuu@aaa.com",
 *     comments="yoyoyo")
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * policy = alicloud.ram.Policy("policy",
 *     policy_name=f"tf-example-{default['result']}",
 *     policy_document="""  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * """,
 *     description="this is a policy test")
 * attach = alicloud.ram.UserPolicyAttachment("attach",
 *     policy_name=policy.policy_name,
 *     policy_type=policy.type,
 *     user_name=user.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a RAM User Policy attachment.
 *     var user = new AliCloud.Ram.User("user", new()
 *     {
 *         Name = "userName",
 *         DisplayName = "user_display_name",
 *         Mobile = "86-18688888888",
 *         Email = "hello.uuu@aaa.com",
 *         Comments = "yoyoyo",
 *     });
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var policy = new AliCloud.Ram.Policy("policy", new()
 *     {
 *         PolicyName = $"tf-example-{@default.Result}",
 *         PolicyDocument = @"  {
 *     ""Statement"": [
 *       {
 *         ""Action"": [
 *           ""oss:ListObjects"",
 *           ""oss:GetObject""
 *         ],
 *         ""Effect"": ""Allow"",
 *         ""Resource"": [
 *           ""acs:oss:*:*:mybucket"",
 *           ""acs:oss:*:*:mybucket/*""
 *         ]
 *       }
 *     ],
 *       ""Version"": ""1""
 *   }
 * ",
 *         Description = "this is a policy test",
 *     });
 *     var attach = new AliCloud.Ram.UserPolicyAttachment("attach", new()
 *     {
 *         PolicyName = policy.PolicyName,
 *         PolicyType = policy.Type,
 *         UserName = user.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a RAM User Policy attachment.
 * 		user, err := ram.NewUser(ctx, "user", &ram.UserArgs{
 * 			Name:        pulumi.String("userName"),
 * 			DisplayName: pulumi.String("user_display_name"),
 * 			Mobile:      pulumi.String("86-18688888888"),
 * 			Email:       pulumi.String("hello.uuu@aaa.com"),
 * 			Comments:    pulumi.String("yoyoyo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy, err := ram.NewPolicy(ctx, "policy", &ram.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			PolicyDocument: pulumi.String(`  {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 * `),
 * 			Description: pulumi.String("this is a policy test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewUserPolicyAttachment(ctx, "attach", &ram.UserPolicyAttachmentArgs{
 * 			PolicyName: policy.PolicyName,
 * 			PolicyType: policy.Type,
 * 			UserName:   user.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ram.Policy;
 * import com.pulumi.alicloud.ram.PolicyArgs;
 * import com.pulumi.alicloud.ram.UserPolicyAttachment;
 * import com.pulumi.alicloud.ram.UserPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a RAM User Policy attachment.
 *         var user = new User("user", UserArgs.builder()
 *             .name("userName")
 *             .displayName("user_display_name")
 *             .mobile("86-18688888888")
 *             .email("hello.uuu@aaa.com")
 *             .comments("yoyoyo")
 *             .build());
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName(String.format("tf-example-%s", default_.result()))
 *             .policyDocument("""
 *   {
 *     "Statement": [
 *       {
 *         "Action": [
 *           "oss:ListObjects",
 *           "oss:GetObject"
 *         ],
 *         "Effect": "Allow",
 *         "Resource": [
 *           "acs:oss:*:*:mybucket",
 *           "acs:oss:*:*:mybucket/*"
 *         ]
 *       }
 *     ],
 *       "Version": "1"
 *   }
 *             """)
 *             .description("this is a policy test")
 *             .build());
 *         var attach = new UserPolicyAttachment("attach", UserPolicyAttachmentArgs.builder()
 *             .policyName(policy.policyName())
 *             .policyType(policy.type())
 *             .userName(user.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a RAM User Policy attachment.
 *   user:
 *     type: alicloud:ram:User
 *     properties:
 *       name: userName
 *       displayName: user_display_name
 *       mobile: 86-18688888888
 *       email: hello.uuu@aaa.com
 *       comments: yoyoyo
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   policy:
 *     type: alicloud:ram:Policy
 *     properties:
 *       policyName: tf-example-${default.result}
 *       policyDocument: |2
 *           {
 *             "Statement": [
 *               {
 *                 "Action": [
 *                   "oss:ListObjects",
 *                   "oss:GetObject"
 *                 ],
 *                 "Effect": "Allow",
 *                 "Resource": [
 *                   "acs:oss:*:*:mybucket",
 *                   "acs:oss:*:*:mybucket/*"
 *                 ]
 *               }
 *             ],
 *               "Version": "1"
 *           }
 *       description: this is a policy test
 *   attach:
 *     type: alicloud:ram:UserPolicyAttachment
 *     properties:
 *       policyName: ${policy.policyName}
 *       policyType: ${policy.type}
 *       userName: ${user.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RAM User Policy attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ram/userPolicyAttachment:UserPolicyAttachment example user:my-policy:Custom:my-user
 * ```
 * @property policyName Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
 * @property policyType Type of the RAM policy. It must be `Custom` or `System`.
 * @property userName Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
 * */*/*/*/*/*/
 */
public data class UserPolicyAttachmentArgs(
    public val policyName: Output<String>? = null,
    public val policyType: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.UserPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.UserPolicyAttachmentArgs =
        com.pulumi.alicloud.ram.UserPolicyAttachmentArgs.builder()
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policyType(policyType?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class UserPolicyAttachmentArgsBuilder internal constructor() {
    private var policyName: Output<String>? = null

    private var policyType: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("ileoxmgpwqwgrhvh")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Type of the RAM policy. It must be `Custom` or `System`.
     */
    @JvmName("wmgnhsoevenfecio")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("npjcqdfibqaumjgc")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Name of the RAM policy. This name can have a string of 1 to 128 characters, must contain only alphanumeric characters or hyphen "-", and must not begin with a hyphen.
     */
    @JvmName("pvhydgpnomjivgqb")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Type of the RAM policy. It must be `Custom` or `System`.
     */
    @JvmName("unljpanwqsmcgmkj")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
     */
    @JvmName("iokmlyprtxddwxqp")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserPolicyAttachmentArgs = UserPolicyAttachmentArgs(
        policyName = policyName,
        policyType = policyType,
        userName = userName,
    )
}
