@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetAccountAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccountAlias.
 * @property outputFile
 */
public data class GetAccountAliasPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetAccountAliasPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetAccountAliasPlainArgs =
        com.pulumi.alicloud.ram.inputs.GetAccountAliasPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountAliasPlainArgs].
 */
@PulumiTagMarker
public class GetAccountAliasPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("tdpncqqvwnakidby")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAccountAliasPlainArgs = GetAccountAliasPlainArgs(
        outputFile = outputFile,
    )
}
