@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetAccountAliasesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccountAliases.
 * @property outputFile
 */
public data class GetAccountAliasesPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetAccountAliasesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetAccountAliasesPlainArgs =
        com.pulumi.alicloud.ram.inputs.GetAccountAliasesPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountAliasesPlainArgs].
 */
@PulumiTagMarker
public class GetAccountAliasesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("vfxewxikfdhamwqe")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAccountAliasesPlainArgs = GetAccountAliasesPlainArgs(
        outputFile = outputFile,
    )
}
