@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroups.
 * @property nameRegex A regex string to filter the returned groups by their names.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyName Filter the results by a specific policy name. If you set this parameter without setting `policy_type`, it will be automatically set to `System`.
 * @property policyType Filter the results by a specific policy type. Valid items are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
 * @property userName Filter the results by a specific the user name.
 */
public data class GetGroupsPlainArgs(
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
    public val userName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetGroupsPlainArgs =
        com.pulumi.alicloud.ram.inputs.GetGroupsPlainArgs.builder()
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyName(policyName?.let({ args0 -> args0 }))
            .policyType(policyType?.let({ args0 -> args0 }))
            .userName(userName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetGroupsPlainArgsBuilder internal constructor() {
    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var policyName: String? = null

    private var policyType: String? = null

    private var userName: String? = null

    /**
     * @param value A regex string to filter the returned groups by their names.
     */
    @JvmName("wjwyiqdopbcedaid")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ybnjrrcbtwttaepl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter the results by a specific policy name. If you set this parameter without setting `policy_type`, it will be automatically set to `System`.
     */
    @JvmName("tfrbiwoxryuuafln")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value Filter the results by a specific policy type. Valid items are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
     */
    @JvmName("qwrowkoqmynbgiew")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyType = mapped
    }

    /**
     * @param value Filter the results by a specific the user name.
     */
    @JvmName("leorxgpftljstyvl")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetGroupsPlainArgs = GetGroupsPlainArgs(
        nameRegex = nameRegex,
        outputFile = outputFile,
        policyName = policyName,
        policyType = policyType,
        userName = userName,
    )
}
