@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicies.
 * @property enableDetails Default to `true`. Set it to true can output more details.
 * @property groupName Filter results by a specific group name. Returned policies are attached to the specified group.
 * @property ids A list of ram group IDs.
 * @property nameRegex A regex string to filter resulting policies by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property roleName Filter results by a specific role name. Returned policies are attached to the specified role.
 * @property type Filter results by a specific policy type. Valid values are `Custom` and `System`.
 * @property userName Filter results by a specific user name. Returned policies are attached to the specified user.
 */
public data class GetPoliciesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val groupName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val roleName: String? = null,
    public val type: String? = null,
    public val userName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetPoliciesPlainArgs =
        com.pulumi.alicloud.ram.inputs.GetPoliciesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .groupName(groupName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .roleName(roleName?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .userName(userName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetPoliciesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var groupName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var roleName: String? = null

    private var type: String? = null

    private var userName: String? = null

    /**
     * @param value Default to `true`. Set it to true can output more details.
     */
    @JvmName("foxyreqgeohhkbia")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value Filter results by a specific group name. Returned policies are attached to the specified group.
     */
    @JvmName("ahgrjgvjcbarhlvj")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value A list of ram group IDs.
     */
    @JvmName("jmwfwfjluxarudxt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ram group IDs.
     */
    @JvmName("jwbvmehurteanynf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter resulting policies by name.
     */
    @JvmName("qfpjqcxlwdqkgudp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xyhkcsgyftanguud")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter results by a specific role name. Returned policies are attached to the specified role.
     */
    @JvmName("eldofcngtvheemkj")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.roleName = mapped
    }

    /**
     * @param value Filter results by a specific policy type. Valid values are `Custom` and `System`.
     */
    @JvmName("uujchvkropwyjaih")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Filter results by a specific user name. Returned policies are attached to the specified user.
     */
    @JvmName("gneqdnjlbovgftyu")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetPoliciesPlainArgs = GetPoliciesPlainArgs(
        enableDetails = enableDetails,
        groupName = groupName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        roleName = roleName,
        type = type,
        userName = userName,
    )
}
