@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicyDocument.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property statements Statement of the RAM policy document. See the following `Block statement`. See `statement` below.
 * @property version Version of the RAM policy document. Valid value is `1`. Default value is `1`.
 */
public data class GetPolicyDocumentPlainArgs(
    public val outputFile: String? = null,
    public val statements: List<GetPolicyDocumentStatement>? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetPolicyDocumentPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetPolicyDocumentPlainArgs =
        com.pulumi.alicloud.ram.inputs.GetPolicyDocumentPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .statements(
                statements?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDocumentPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyDocumentPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var statements: List<GetPolicyDocumentStatement>? = null

    private var version: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jpxflvdbnanvpkan")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Statement of the RAM policy document. See the following `Block statement`. See `statement` below.
     */
    @JvmName("vnbjxqnttqyloedk")
    public suspend fun statements(`value`: List<GetPolicyDocumentStatement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statements = mapped
    }

    /**
     * @param argument Statement of the RAM policy document. See the following `Block statement`. See `statement` below.
     */
    @JvmName("evpfrilrjhmehdhy")
    public suspend fun statements(argument: List<suspend GetPolicyDocumentStatementBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param argument Statement of the RAM policy document. See the following `Block statement`. See `statement` below.
     */
    @JvmName("ecykrbifubnaeopm")
    public suspend fun statements(vararg argument: suspend GetPolicyDocumentStatementBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param argument Statement of the RAM policy document. See the following `Block statement`. See `statement` below.
     */
    @JvmName("uvwwsrnkoyfjnvkt")
    public suspend fun statements(argument: suspend GetPolicyDocumentStatementBuilder.() -> Unit) {
        val toBeMapped = listOf(GetPolicyDocumentStatementBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param values Statement of the RAM policy document. See the following `Block statement`. See `statement` below.
     */
    @JvmName("ntktykssgqvvlatb")
    public suspend fun statements(vararg values: GetPolicyDocumentStatement) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statements = mapped
    }

    /**
     * @param value Version of the RAM policy document. Valid value is `1`. Default value is `1`.
     */
    @JvmName("dloxcjtylsgjnrau")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetPolicyDocumentPlainArgs = GetPolicyDocumentPlainArgs(
        outputFile = outputFile,
        statements = statements,
        version = version,
    )
}
