@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatement.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions Action of the RAM policy document. If you want to create a RAM role policy document, it must be `["sts:AssumeRole"]`.
 * @property conditions Specifies the condition that are required for a policy to take effect. See `condition` below.
 * @property effect This parameter indicates whether or not the `action` is allowed. Valid values are `Allow` and `Deny`. Default value is `Allow`. If you want to create a RAM role policy document, it must be `Allow`.
 * @property principals Principal of the RAM policy document. If you want to create a RAM role policy document, it must be set. See `principal` below.
 * @property resources List of specific objects which will be authorized. If you want to create a RAM policy document, it must be set.
 */
public data class GetPolicyDocumentStatement(
    public val actions: List<String>,
    public val conditions: List<GetPolicyDocumentStatementCondition>? = null,
    public val effect: String? = null,
    public val principals: List<GetPolicyDocumentStatementPrincipal>? = null,
    public val resources: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatement> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatement =
        com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatement.builder()
            .actions(actions.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .conditions(
                conditions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .effect(effect?.let({ args0 -> args0 }))
            .principals(
                principals?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resources(resources?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetPolicyDocumentStatement].
 */
@PulumiTagMarker
public class GetPolicyDocumentStatementBuilder internal constructor() {
    private var actions: List<String>? = null

    private var conditions: List<GetPolicyDocumentStatementCondition>? = null

    private var effect: String? = null

    private var principals: List<GetPolicyDocumentStatementPrincipal>? = null

    private var resources: List<String>? = null

    /**
     * @param value Action of the RAM policy document. If you want to create a RAM role policy document, it must be `["sts:AssumeRole"]`.
     */
    @JvmName("qrokglmxibwrgrbl")
    public suspend fun actions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.actions = mapped
    }

    /**
     * @param values Action of the RAM policy document. If you want to create a RAM role policy document, it must be `["sts:AssumeRole"]`.
     */
    @JvmName("yleakumnipokqjli")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.actions = mapped
    }

    /**
     * @param value Specifies the condition that are required for a policy to take effect. See `condition` below.
     */
    @JvmName("asggrxltiajqpdwa")
    public suspend fun conditions(`value`: List<GetPolicyDocumentStatementCondition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.conditions = mapped
    }

    /**
     * @param argument Specifies the condition that are required for a policy to take effect. See `condition` below.
     */
    @JvmName("pccvdcqbofnhqfgt")
    public suspend fun conditions(argument: List<suspend GetPolicyDocumentStatementConditionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementConditionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param argument Specifies the condition that are required for a policy to take effect. See `condition` below.
     */
    @JvmName("vcfkhtgviroegcsu")
    public suspend fun conditions(vararg argument: suspend GetPolicyDocumentStatementConditionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementConditionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param argument Specifies the condition that are required for a policy to take effect. See `condition` below.
     */
    @JvmName("ikfuvaapwbiechxy")
    public suspend fun conditions(argument: suspend GetPolicyDocumentStatementConditionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPolicyDocumentStatementConditionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param values Specifies the condition that are required for a policy to take effect. See `condition` below.
     */
    @JvmName("orqhglwiqmqqnpcs")
    public suspend fun conditions(vararg values: GetPolicyDocumentStatementCondition) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.conditions = mapped
    }

    /**
     * @param value This parameter indicates whether or not the `action` is allowed. Valid values are `Allow` and `Deny`. Default value is `Allow`. If you want to create a RAM role policy document, it must be `Allow`.
     */
    @JvmName("xjfmthldopkqaymg")
    public suspend fun effect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.effect = mapped
    }

    /**
     * @param value Principal of the RAM policy document. If you want to create a RAM role policy document, it must be set. See `principal` below.
     */
    @JvmName("gtbafbviongisuxv")
    public suspend fun principals(`value`: List<GetPolicyDocumentStatementPrincipal>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.principals = mapped
    }

    /**
     * @param argument Principal of the RAM policy document. If you want to create a RAM role policy document, it must be set. See `principal` below.
     */
    @JvmName("yyqwqvltnufrgkcx")
    public suspend fun principals(argument: List<suspend GetPolicyDocumentStatementPrincipalBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementPrincipalBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.principals = mapped
    }

    /**
     * @param argument Principal of the RAM policy document. If you want to create a RAM role policy document, it must be set. See `principal` below.
     */
    @JvmName("iwjjxftpayoiwgwp")
    public suspend fun principals(vararg argument: suspend GetPolicyDocumentStatementPrincipalBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementPrincipalBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.principals = mapped
    }

    /**
     * @param argument Principal of the RAM policy document. If you want to create a RAM role policy document, it must be set. See `principal` below.
     */
    @JvmName("ybqqrkbqycxakuyt")
    public suspend fun principals(argument: suspend GetPolicyDocumentStatementPrincipalBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPolicyDocumentStatementPrincipalBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.principals = mapped
    }

    /**
     * @param values Principal of the RAM policy document. If you want to create a RAM role policy document, it must be set. See `principal` below.
     */
    @JvmName("ddsfvorvemcuhbef")
    public suspend fun principals(vararg values: GetPolicyDocumentStatementPrincipal) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principals = mapped
    }

    /**
     * @param value List of specific objects which will be authorized. If you want to create a RAM policy document, it must be set.
     */
    @JvmName("whlryvjkalocfrcr")
    public suspend fun resources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resources = mapped
    }

    /**
     * @param values List of specific objects which will be authorized. If you want to create a RAM policy document, it must be set.
     */
    @JvmName("bfvxpdhyuownvohl")
    public suspend fun resources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resources = mapped
    }

    internal fun build(): GetPolicyDocumentStatement = GetPolicyDocumentStatement(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        conditions = conditions,
        effect = effect,
        principals = principals,
        resources = resources,
    )
}
