@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementCondition.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property operator The operator of the condition.
 * @property values The values of the condition.
 * @property variable The variable of the condition.
 */
public data class GetPolicyDocumentStatementCondition(
    public val `operator`: String,
    public val values: List<String>,
    public val variable: String,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementCondition> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementCondition =
        com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementCondition.builder()
            .`operator`(`operator`.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .variable(variable.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDocumentStatementCondition].
 */
@PulumiTagMarker
public class GetPolicyDocumentStatementConditionBuilder internal constructor() {
    private var `operator`: String? = null

    private var values: List<String>? = null

    private var variable: String? = null

    /**
     * @param value The operator of the condition.
     */
    @JvmName("aereqvfbrghpvnkv")
    public suspend fun `operator`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.`operator` = mapped
    }

    /**
     * @param value The values of the condition.
     */
    @JvmName("njvhewlqabjiweao")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values The values of the condition.
     */
    @JvmName("fyyupsysxnrcmppe")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param value The variable of the condition.
     */
    @JvmName("vtqlbxhulusnmwsa")
    public suspend fun variable(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variable = mapped
    }

    internal fun build(): GetPolicyDocumentStatementCondition = GetPolicyDocumentStatementCondition(
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        values = values ?: throw PulumiNullFieldException("values"),
        variable = variable ?: throw PulumiNullFieldException("variable"),
    )
}
