@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementPrincipal.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property entity The trusted entity. Valid values: `RAM`, `Service` and `Federated`.
 * @property identifiers The identifiers of the principal.
 */
public data class GetPolicyDocumentStatementPrincipal(
    public val entity: String,
    public val identifiers: List<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementPrincipal> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementPrincipal =
        com.pulumi.alicloud.ram.inputs.GetPolicyDocumentStatementPrincipal.builder()
            .entity(entity.let({ args0 -> args0 }))
            .identifiers(identifiers.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetPolicyDocumentStatementPrincipal].
 */
@PulumiTagMarker
public class GetPolicyDocumentStatementPrincipalBuilder internal constructor() {
    private var entity: String? = null

    private var identifiers: List<String>? = null

    /**
     * @param value The trusted entity. Valid values: `RAM`, `Service` and `Federated`.
     */
    @JvmName("epxcxqdtrhyhqqnh")
    public suspend fun entity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.entity = mapped
    }

    /**
     * @param value The identifiers of the principal.
     */
    @JvmName("ydpxbwsfrgdvuncb")
    public suspend fun identifiers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identifiers = mapped
    }

    /**
     * @param values The identifiers of the principal.
     */
    @JvmName("frwwnsovfcoakepm")
    public suspend fun identifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identifiers = mapped
    }

    internal fun build(): GetPolicyDocumentStatementPrincipal = GetPolicyDocumentStatementPrincipal(
        entity = entity ?: throw PulumiNullFieldException("entity"),
        identifiers = identifiers ?: throw PulumiNullFieldException("identifiers"),
    )
}
