@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetRolesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRoles.
 * @property ids A list of ram role IDs.
 * @property nameRegex A regex string to filter results by the role name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyName Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. The resulting roles will be attached to the specified policy.
 * @property policyType Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
 */
public data class GetRolesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetRolesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetRolesPlainArgs =
        com.pulumi.alicloud.ram.inputs.GetRolesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyName(policyName?.let({ args0 -> args0 }))
            .policyType(policyType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRolesPlainArgs].
 */
@PulumiTagMarker
public class GetRolesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var policyName: String? = null

    private var policyType: String? = null

    /**
     * @param value A list of ram role IDs.
     */
    @JvmName("ltiaehkigkqmxgpy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ram role IDs.
     */
    @JvmName("gpvihllehxhtknra")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by the role name.
     */
    @JvmName("semcjdndmktfbelt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("eahvruycelnymggy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. The resulting roles will be attached to the specified policy.
     */
    @JvmName("vgetqmnlpmgdompi")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
     */
    @JvmName("bxyoyklxbvtfsnqw")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyType = mapped
    }

    internal fun build(): GetRolesPlainArgs = GetRolesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        policyName = policyName,
        policyType = policyType,
    )
}
