@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.inputs

import com.pulumi.alicloud.ram.inputs.GetUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUsers.
 * @property groupName Filter results by a specific group name. Returned users are in the specified group.
 * @property ids A list of ram user IDs.
 * @property nameRegex A regex string to filter resulting users by their names.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policyName Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. Returned users are attached to the specified policy.
 * @property policyType Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
 */
public data class GetUsersPlainArgs(
    public val groupName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ram.inputs.GetUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ram.inputs.GetUsersPlainArgs =
        com.pulumi.alicloud.ram.inputs.GetUsersPlainArgs.builder()
            .groupName(groupName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policyName(policyName?.let({ args0 -> args0 }))
            .policyType(policyType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUsersPlainArgs].
 */
@PulumiTagMarker
public class GetUsersPlainArgsBuilder internal constructor() {
    private var groupName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var policyName: String? = null

    private var policyType: String? = null

    /**
     * @param value Filter results by a specific group name. Returned users are in the specified group.
     */
    @JvmName("spteuasiubvsopdq")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value A list of ram user IDs.
     */
    @JvmName("emaksfoanvqqicjw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ram user IDs.
     */
    @JvmName("mcdewbjdsorrekvr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter resulting users by their names.
     */
    @JvmName("gojnccxvaihbitnx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rtxrucrpgrrtwvtp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter results by a specific policy name. If you set this parameter without setting `policy_type`, the later will be automatically set to `System`. Returned users are attached to the specified policy.
     */
    @JvmName("xgacyhvvpmafdlpx")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value Filter results by a specific policy type. Valid values are `Custom` and `System`. If you set this parameter, you must set `policy_name` as well.
     */
    @JvmName("ryjgbbrpcykcbvrx")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyType = mapped
    }

    internal fun build(): GetUsersPlainArgs = GetUsersPlainArgs(
        groupName = groupName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        policyName = policyName,
        policyType = policyType,
    )
}
