@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAccountAlias.
 * @property accountAlias
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 */
public data class GetAccountAliasResult(
    public val accountAlias: String,
    public val id: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetAccountAliasResult): GetAccountAliasResult = GetAccountAliasResult(
            accountAlias = javaType.accountAlias(),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
