@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroups.
 * @property groups A list of groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nameRegex
 * @property names A list of ram group names.
 * @property outputFile
 * @property policyName
 * @property policyType
 * @property userName
 */
public data class GetGroupsResult(
    public val groups: List<GetGroupsGroup>,
    public val id: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetGroupsResult): GetGroupsResult = GetGroupsResult(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ram.kotlin.outputs.GetGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
