@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attachmentCount Attachment count of the policy.
 * @property createDate Creation date of the policy.
 * @property defaultVersion Default version of the policy.
 * @property description Description of the policy.
 * @property document Policy document of the policy.
 * @property id ID of the policy.
 * @property name Name of the policy.
 * @property policyDocument Policy document of the policy.
 * @property policyName Name of the policy.
 * @property type Filter results by a specific policy type. Valid values are `Custom` and `System`.
 * @property updateDate Update date of the policy.
 * @property userName Filter results by a specific user name. Returned policies are attached to the specified user.
 * @property versionId The ID of default policy.
 */
public data class GetPoliciesPolicy(
    public val attachmentCount: Int,
    public val createDate: String,
    public val defaultVersion: String,
    public val description: String,
    public val document: String,
    public val id: String,
    public val name: String,
    public val policyDocument: String,
    public val policyName: String,
    public val type: String,
    public val updateDate: String,
    public val userName: String,
    public val versionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetPoliciesPolicy): GetPoliciesPolicy = GetPoliciesPolicy(
            attachmentCount = javaType.attachmentCount(),
            createDate = javaType.createDate(),
            defaultVersion = javaType.defaultVersion(),
            description = javaType.description(),
            document = javaType.document(),
            id = javaType.id(),
            name = javaType.name(),
            policyDocument = javaType.policyDocument(),
            policyName = javaType.policyName(),
            type = javaType.type(),
            updateDate = javaType.updateDate(),
            userName = javaType.userName(),
            versionId = javaType.versionId(),
        )
    }
}
