@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicies.
 * @property enableDetails
 * @property groupName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of ram group names.
 * @property outputFile
 * @property policies A list of policies. Each element contains the following attributes:
 * @property roleName
 * @property type Type of the policy.
 * @property userName The user name of  policy.
 */
public data class GetPoliciesResult(
    public val enableDetails: Boolean? = null,
    public val groupName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val policies: List<GetPoliciesPolicy>,
    public val roleName: String? = null,
    public val type: String? = null,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetPoliciesResult): GetPoliciesResult = GetPoliciesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ram.kotlin.outputs.GetPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
