@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicyDocument.
 * @property document Standard policy document rendered based on the arguments above.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property statements
 * @property version
 */
public data class GetPolicyDocumentResult(
    public val document: String,
    public val id: String,
    public val outputFile: String? = null,
    public val statements: List<GetPolicyDocumentStatement>? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetPolicyDocumentResult): GetPolicyDocumentResult = GetPolicyDocumentResult(
            document = javaType.document(),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            statements = javaType.statements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ram.kotlin.outputs.GetPolicyDocumentStatement.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
