@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions Action of the RAM policy document. If you want to create a RAM role policy document, it must be `["sts:AssumeRole"]`.
 * @property conditions Specifies the condition that are required for a policy to take effect. See `condition` below.
 * @property effect This parameter indicates whether or not the `action` is allowed. Valid values are `Allow` and `Deny`. Default value is `Allow`. If you want to create a RAM role policy document, it must be `Allow`.
 * @property principals Principal of the RAM policy document. If you want to create a RAM role policy document, it must be set. See `principal` below.
 * @property resources List of specific objects which will be authorized. If you want to create a RAM policy document, it must be set.
 */
public data class GetPolicyDocumentStatement(
    public val actions: List<String>,
    public val conditions: List<GetPolicyDocumentStatementCondition>? = null,
    public val effect: String? = null,
    public val principals: List<GetPolicyDocumentStatementPrincipal>? = null,
    public val resources: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetPolicyDocumentStatement): GetPolicyDocumentStatement = GetPolicyDocumentStatement(
            actions = javaType.actions().map({ args0 -> args0 }),
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ram.kotlin.outputs.GetPolicyDocumentStatementCondition.Companion.toKotlin(args0)
                })
            }),
            effect = javaType.effect().map({ args0 -> args0 }).orElse(null),
            principals = javaType.principals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ram.kotlin.outputs.GetPolicyDocumentStatementPrincipal.Companion.toKotlin(args0)
                })
            }),
            resources = javaType.resources().map({ args0 -> args0 }),
        )
    }
}
