@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property entity The trusted entity. Valid values: `RAM`, `Service` and `Federated`.
 * @property identifiers The identifiers of the principal.
 */
public data class GetPolicyDocumentStatementPrincipal(
    public val entity: String,
    public val identifiers: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetPolicyDocumentStatementPrincipal): GetPolicyDocumentStatementPrincipal = GetPolicyDocumentStatementPrincipal(
            entity = javaType.entity(),
            identifiers = javaType.identifiers().map({ args0 -> args0 }),
        )
    }
}
