@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn Resource descriptor of the role.
 * @property assumeRolePolicyDocument Authorization strategy of the role. This parameter is deprecated and replaced by `document`.
 * @property createDate Creation date of the role.
 * @property description Description of the role.
 * @property document Authorization strategy of the role.
 * @property id ID of the role.
 * @property name Name of the role.
 * @property updateDate Update date of the role.
 */
public data class GetRolesRole(
    public val arn: String,
    public val assumeRolePolicyDocument: String,
    public val createDate: String,
    public val description: String,
    public val document: String,
    public val id: String,
    public val name: String,
    public val updateDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetRolesRole): GetRolesRole =
            GetRolesRole(
                arn = javaType.arn(),
                assumeRolePolicyDocument = javaType.assumeRolePolicyDocument(),
                createDate = javaType.createDate(),
                description = javaType.description(),
                document = javaType.document(),
                id = javaType.id(),
                name = javaType.name(),
                updateDate = javaType.updateDate(),
            )
    }
}
