@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the IdP.
 * @property description The description of SAML Provider.
 * @property encodedsamlMetadataDocument The encodedsaml metadata document.
 * @property id The ID of the SAML Provider.
 * @property samlProviderName The saml provider name.
 * @property updateDate The update time.
 */
public data class GetSamlProvidersProvider(
    public val arn: String,
    public val description: String,
    public val encodedsamlMetadataDocument: String,
    public val id: String,
    public val samlProviderName: String,
    public val updateDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetSamlProvidersProvider): GetSamlProvidersProvider = GetSamlProvidersProvider(
            arn = javaType.arn(),
            description = javaType.description(),
            encodedsamlMetadataDocument = javaType.encodedsamlMetadataDocument(),
            id = javaType.id(),
            samlProviderName = javaType.samlProviderName(),
            updateDate = javaType.updateDate(),
        )
    }
}
