@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSamlProviders.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of SAML Provider names.
 * @property outputFile
 * @property providers A list of Ram Saml Providers. Each element contains the following attributes:
 */
public data class GetSamlProvidersResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val providers: List<GetSamlProvidersProvider>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetSamlProvidersResult): GetSamlProvidersResult = GetSamlProvidersResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            providers = javaType.providers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ram.kotlin.outputs.GetSamlProvidersProvider.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
