@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUsers.
 * @property groupName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of ram user IDs.
 * @property nameRegex
 * @property names A list of ram user's name.
 * @property outputFile
 * @property policyName
 * @property policyType
 * @property users A list of users. Each element contains the following attributes:
 */
public data class GetUsersResult(
    public val groupName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
    public val users: List<GetUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetUsersResult): GetUsersResult =
            GetUsersResult(
                groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
                policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
                users = javaType.users().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ram.kotlin.outputs.GetUsersUser.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
