@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ram.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createDate Creation date of the user.
 * @property id The original id is user's name, but it is user id in 1.37.0+.
 * @property lastLoginDate (Removed) Last login date of the user. Removed from version 1.79.0.
 * @property name Name of the user.
 */
public data class GetUsersUser(
    public val createDate: String,
    public val id: String,
    public val lastLoginDate: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ram.outputs.GetUsersUser): GetUsersUser =
            GetUsersUser(
                createDate = javaType.createDate(),
                id = javaType.id(),
                lastLoginDate = javaType.lastLoginDate(),
                name = javaType.name(),
            )
    }
}
