@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rdc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Organization].
 */
@PulumiTagMarker
public class OrganizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationArgs = OrganizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationArgsBuilder.() -> Unit) {
        val builder = OrganizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Organization {
        val builtJavaResource = com.pulumi.alicloud.rdc.Organization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Organization(builtJavaResource)
    }
}

/**
 * Provides a RDC Organization resource.
 * For information about RDC Organization and how to use it, see [What is Organization](https://help.aliyun.com/document_detail/51678.html).
 * > **NOTE:** Available in v1.137.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.rdc.Organization("example", {
 *     organizationName: "example_value",
 *     source: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.rdc.Organization("example",
 *     organization_name="example_value",
 *     source="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Rdc.Organization("example", new()
 *     {
 *         OrganizationName = "example_value",
 *         Source = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rdc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rdc.NewOrganization(ctx, "example", &rdc.OrganizationArgs{
 * 			OrganizationName: pulumi.String("example_value"),
 * 			Source:           pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rdc.Organization;
 * import com.pulumi.alicloud.rdc.OrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Organization("example", OrganizationArgs.builder()
 *             .organizationName("example_value")
 *             .source("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:rdc:Organization
 *     properties:
 *       organizationName: example_value
 *       source: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDC Organization can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rdc/organization:Organization example <id>
 * ```
 */
public class Organization internal constructor(
    override val javaResource: com.pulumi.alicloud.rdc.Organization,
) : KotlinCustomResource(javaResource, OrganizationMapper) {
    /**
     * The desired member count.
     */
    public val desiredMemberCount: Output<Int>?
        get() = javaResource.desiredMemberCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Company name.
     */
    public val organizationName: Output<String>
        get() = javaResource.organizationName().applyValue({ args0 -> args0 })

    /**
     * User pk, not required, only required when the ak used by the calling interface is inconsistent with the user pk
     */
    public val realPk: Output<String>?
        get() = javaResource.realPk().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This is organization source information
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })
}

public object OrganizationMapper : ResourceMapper<Organization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rdc.Organization::class == javaResource::class

    override fun map(javaResource: Resource): Organization = Organization(
        javaResource as
            com.pulumi.alicloud.rdc.Organization,
    )
}

/**
 * @see [Organization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Organization].
 */
public suspend fun organization(
    name: String,
    block: suspend OrganizationResourceBuilder.() -> Unit,
): Organization {
    val builder = OrganizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Organization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organization(name: String): Organization {
    val builder = OrganizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
